/****************************************************************/
/*             Creation of Weasel desktop folder                */
/*    Based on a script supplied by Antonio Manara Rossini      */
/****************************************************************/

/* Register with REXX API extensions. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

Say 'Weasel for OS/2 - Installation Script.'
Say
Say 'Create Weasel for OS/2 folder and icons.'
Say
Say 'NOTE: This program needs to be executed from the installation directory'
Say '      of your working Weasel setup.'
Say
CreateCollision = 'Replace'

Call CreateObjects
Exit

CreateObject: procedure
    Parse Arg Class, Title, Location, Setup, Collision
    Say 'Creating ['Title']'
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        Say ' > failed to create ['Title' | 'Class'] at location ['Location']'
    return rc

CreateShadow: procedure
    Parse Arg Original, Location
    Say 'Creating Shadow of 'Original
    rc = SysCreateShadow( Original, Location )
    If rc <> 1 Then
        Say ' > failed to create shadow of 'Original' at location ['Location']'
    return rc

CreateObjects:

current_dir = directory()

/***************/
/* MAIN FOLDER */
/***************/

rc = CreateObject( 'WPFolder',,
    'Weasel',,
    '<WP_DESKTOP>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,NORMAL;'||,
        'ALWAYSSORT=YES;'||,
        'ICONFILE='||current_dir||'\Wefold1.ico;'||,
        'ICONNFILE=1,'||current_dir||'\Wefold2.ico;'||,
        'OBJECTID=<Weasel_folder>',,
    CreateCollision )

/***************************/
/*  OBJECTS IN MAIN FOLDER */
/***************************/

  rc = CreateShadow(current_dir||'\README.FILTERS', '<Weasel_folder>')

  rc = CreateObject( 'WPProgram',,
      'Weasel Daemon',,
      '<Weasel_folder>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||current_dir||'\WEASEL.EXE;'||,
          'STARTUPDIR='||current_dir||';'||,
          'MINIMIZED=YES;'||,
          'OBJECTID=<Weasel_Daemon>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Weasel Setup',,
      '<Weasel_folder>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||current_dir||'\SETUP.EXE;'||,
          'STARTUPDIR='||current_dir||';'||,
          'OBJECTID=<Weasel_PMSetup>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Weasel Manual',,
      '<Weasel_folder>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||'VIEW.EXE;'||,
          'PARAMETERS='||current_dir||'\WEASEL.INF;'||,
          'STARTUPDIR='||current_dir||';'||,
          'MINIMIZED=NO;'||,
          'OBJECTID=<Weasel_Manual>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Technical supplement to Weasel Manual',,
      '<Weasel_folder>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||'VIEW.EXE;'||,
          'PARAMETERS='||current_dir||'\TECHDATA.INF;'||,
          'STARTUPDIR='||current_dir||';'||,
          'MINIMIZED=NO;'||,
          'OBJECTID=<WeaselPro_Manual>',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'Tools',,
      '<Weasel_folder>',,
      'SHADOWID='||current_dir||'\Tools',,
      CreateCollision )

  rc = CreateObject( 'WPURL',,
      'More tools and accessories',,
      '<Weasel_folder>',,
      'NOPRINT=YES;'||,
          'URL=http://www.pmoylan.org/pages/os2/waccess.html',,
      CreateCollision )

return

