// Main
// This program outputs a Upper and Lower bound around a
//  computed prediction based on previous data about estimated
//  and actual LOC occurances.  All the data is printed to the
//  screen, but the input data must come from a file.

#include "conio.h"                // So I can use clrscr().
#include "rfind.h"                // RangeFinder Class.  (workhorse)

void main(int argc, char *argv[])
{
  RangeFinder RF;                 // Instantiate RangeFinder.

  char filename[50];              // Filename
  char temp[50];                  // text buffer.
  double percent=0;               // Percent of error to look for.
  double estimate=0;              // New estimated LOC.

  strcpy(filename, argv[1]);
//  gets(filename);                 // Get the file for input data.
//  printf("%s",filename);

//  gets(temp);
  strcpy(temp, argv[2]);
  percent=atof(temp);             // Find the % confidence desired.


//  gets(temp);                     // Estimated LOC for the program.
  strcpy(temp, argv[3]);
  estimate=atof(temp);            // Find the estimate.

                                  // Do all the work.
  RF.CalcRange(percent, filename, estimate);

                                  // Print the results found.
  FILE *out;

  if (NULL== (out=fopen("data.dat","wt"))){
    perror("Couldn't open data.dat");
    exit(1);
  }
  fprintf(out,"B0         %lf\n",RF.B0);
  fprintf(out,"B1         %lf\n",RF.B1);
  fprintf(out,"Range      %lf\n",RF.Range);
  fprintf(out,"Projection %lf\n",RF.PLOC);
  fprintf(out,"UPI        %lf\n",RF.UPI);
  fprintf(out,"LPI        %lf\n",RF.LPI);

}







