/* Store all EAs on drive */

CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs

CALL SysCls

Backup = 0
CTRPAD = 80

/*---------------------------------------------------------------/
/    Check for No Arguments on command line                      /
/---------------------------------------------------------------*/

if ARG(1) = '' then signal ShortHelp

/*---------------------------------------------------------------/
/    If argument passed, display warning message                 /
/---------------------------------------------------------------*/

if ARG(1) \= '' then

/*---------------------------------------------------------------/
/    Warning message to user before overwriting EA files         /
/---------------------------------------------------------------*/
     CALL SysCls
     SAY " "
     SAY " "
     SAY " "
     SAY " "
     SAY CENTER('WARNING!!!', CTRPAD)
     SAY " "
     SAY CENTER('All EA backups will be overwritten', CTRPAD)
     SAY " "
     SAY CENTER('Press ''N'' to Cancel Backup', CTRPAD)
     SAY " "
     SAY CENTER('Any other key to Continue', CTRPAD)

/*---------------------------------------------------------------/
/    Allow user to cancel in answer to warning message           /
/---------------------------------------------------------------*/

key = SysGetKey(NOECHO)
PARSE UPPER VAR key key
     if key = 'N' then do
     CALL SysCls
     EXIT
     end

/*---------------------------------------------------------------/
/    Translate possible Drive letter entries                     /
/---------------------------------------------------------------*/

DRV = ARG(1)   /* assign argument a variable for parsing */

PARSE UPPER VAR DRV DRV  /* change variable entry to uppercase */

Select
     when DRV = 'C' then
          Drive = 'C:\'
     when DRV = 'D' then
          Drive = 'D:\'
     when DRV = 'E' then
          Drive = 'E:\'          
     when DRV = 'F' then
          Drive = 'F:\'
     when DRV = 'G' then
          Drive = 'G:\'
     when DRV = 'H' then
          Drive = 'H:\'
     when DRV = 'I' then
          Drive = 'I:\'
     otherwise signal ShortHelp
     end

/*---------------------------------------------------------------/
/    Notify User of acceptance                                   /
/---------------------------------------------------------------*/

SAY ' '
SAY CENTER(Processing..., CTRPAD)
SAY ' '

/*---------------------------------------------------------------/
/    If /EAS dir doesn't exist, create it                        /
/---------------------------------------------------------------*/

CALL SysFileTree'eas','junk','D'
IF RC <> 0 then
     do
          CALL SysMkDir Drive||'eas'
          SAY " "
          SAY CENTER('Creating 'Drive||EAS, CTRPAD)
          SAY ' '
          SAY CENTER(DONE, CTRPAD)
          SAY ' '
          SAY CENTER('Reading Files from Directories...', CTRPAD)
     end

/*---------------------------------------------------------------/
/    Load the drive's file tree structure into an array          /
/---------------------------------------------------------------*/

CALL SysFileTree Drive||'*.*', 'FileTree', 'FOS'
SAY ' '
SAY CENTER(done, CTRPAD)
SAY ' '
SAY CENTER('Opening temp file...', CTRPAD)

/*---------------------------------------------------------------/
/    Create necessary dirs, files, etc...                        /
/---------------------------------------------------------------*/

OutDir = Drive||'EAS\'
CurDir = DIRECTORY()
NewDir = DIRECTORY(OutDir)

SAY ' '
SAY CENTER(done,CTRPAD)

/*---------------------------------------------------------------/
/    Delete files inaccessible to EAUTIL                         /
/---------------------------------------------------------------*/

SAY ' '
SAY CENTER('Deleting . SF files from list...', CTRPAD)

Filelist.0 = Filetree.0

do i = 1 to FileTree.0
          RC = COMPARE(FileTree.i, Drive||'WP ROOT. SF')
               if RC = 0 then iterate
          RC = COMPARE(FileTree.i, Drive||'EA DATA. SF')
               if RC = 0 then iterate
          FileList.i = FileTree.i
end

DROP FileTree

SAY ' '
SAY CENTER(done, CTRPAD)

SAY ' '
SAY CENTER('Creating backup Ea files...', CTRPAD)

Eafiles. = ''

do i = 1 to FileList.0
     SlashPos = LASTPOS('\', FileList.i)
     WorkDir = DELSTR(FileList.i, 1, (SlashPos))
     FileOut = INSERT(OutDir, WorkDir)
     EAUTIL FileList.i FileOut "/P /S /R"
     CALL SysFileTree FileOut, 'Eafiles', 'FO'
     if Eafiles.1 = '' then iterate
     else CALL LINEOUT Drive||'EAS\EADIR.LST', FileList.i
     Eafiles.1 = ''
end

CALL STREAM EADIR.LST, C, CLOSE

DROP FileList

CALL SysCls
SAY ' '
SAY ' '
SAY ' '
SAY ' '
SAY ' '
SAY CENTER('Read 'Drive||'EAS\EADIR.LST to view stored EA files', CTRPAD)
SAY ' '

EXIT
/*---------------------------------------------------------------/
/    Short version of help for no arguments on command line      /
/---------------------------------------------------------------*/

ShortHelp:
     do
          CALL SysCls
          SAY " "
          SAY " "
          SAY " "
          SAY ' '
          SAY CENTER('Example Usage:  RXBAKEAS C', CTRPAD)
          SAY " "
          SAY ' '
          SAY CENTER('Drives beyond I not supported', CTRPAD)
          SAY ' '
          SAY CENTER('(View README.1ST file for help, clues, etc.)', CTRPAD)
          EXIT
     END
