@echo off
IF %1. == . goto USAGE

SET TAPEDIR=%TEMP%\TAR.DIR
SET LOGFILE="%TEMP%\TAR.LOG"

echo Initializing Tape
tape stat >NUL 2>NUL
tape sel 1 >NUL 2>NUL
del %TAPEDIR% >NUL 2>&1

echo Reading Tape Directory...

IF %1. == contents. goto CONTENTS
IF %1. == logfile. goto LOGFILE

tar -xppP
tape sel 0 >NUL 2>&1
echo Restoring requested file(s)...
IF %1. == -P. goto ABSOLUTE
tar -xvpp -D %TAPEDIR% %1 %2 %3 %4 %5 %6 %7 %8 %9
goto DONE
:ABSOLUTE
tar -xvpp %1 -D %TAPEDIR% %2 %3 %4 %5 %6 %7 %8 %9
:DONE
echo Done.
del %TAPEDIR% >NUL 2>&1
goto OUT

:CONTENTS
tar -xppP
IF %2. == . goto LISTCONTENTS
copy %TAPEDIR% %2.
del %TAPEDIR%
goto CONTENTSDONE
:LISTCONTENTS
type %TAPEDIR% |more
del %TAPEDIR% >NUL 2>&1
:CONTENTSDONE
goto OUT

:LOGFILE
tape file >NUL 2>NUL
tar -xppP 
IF %2. == . goto LISTLOG
copy %LOGFILE% %2.
del %LOGFILE%
goto LOGDONE
:LISTLOG
type %LOGFILE% |more
del %LOGFILE% >NUL 2>&1
:LOGDONE
goto OUT


:USAGE
echo Usage: TREST [-P] [File(s)]
echo e. g.: TREST 1 d:/CONFIG.SYS
echo        TREST 1 d:/CONFIG.SYS -P
echo Att. : Please use foreward slashes for filenames!
echo        Placeholders are accepted when put in "".
echo e. g.: TREST 2 "d:/*"
:OUT
