package net.sf.colossus.client;


import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import junit.framework.TestCase;
import net.sf.colossus.server.VariantSupport;
import net.sf.colossus.util.Log;


/** Test helper */
class AllPredictSplits extends ArrayList
{
    PredictSplitNode getLeaf(String markerId)
    {
        for (Iterator it = iterator(); it.hasNext(); )
        {
            PredictSplits ps = (PredictSplits)it.next();
            PredictSplitNode leaf = ps.getLeaf(markerId);
            if (leaf != null)
            {
                return leaf;
            }
        }
        return null;
    }

    void printLeaves()
    {
        for (Iterator it = iterator(); it.hasNext(); )
        {
            PredictSplits ps = (PredictSplits)it.next();
            ps.printLeaves();
        }
    }

    void printNodes()
    {
        for (Iterator it = iterator(); it.hasNext(); )
        {
            PredictSplits ps = (PredictSplits)it.next();
            ps.printNodes();
        }
    }
}


/**
 *  JUnit test for split prediction.
 *  @version $Id: PredictSplitsTest.java,v 1.27 2004/04/09 21:29:20 dripton Exp $
 *  @author David Ripton
 */
public class PredictSplitsTest extends TestCase
{
    List cnl;
    AllPredictSplits aps;
    PredictSplits ps;
    int turn = 0;

    public PredictSplitsTest(String name)
    {
        super(name);
    }

    protected void setUp()
    {
        VariantSupport.loadVariant("Default", true);
        aps = new AllPredictSplits();

        cnl = new ArrayList();
        cnl.add("Titan");
        cnl.add("Angel");
        cnl.add("Centaur");
        cnl.add("Centaur");
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        cnl.add("Ogre");
        cnl.add("Ogre");
    }

    public void testPredictSplits1()
    {
        Log.debug("testPredictSplits1()");
        ps = new PredictSplits("Red", "Rd01", cnl);

        turn = 1;
        Log.debug("Turn " + turn);
        PredictSplitNode root = ps.getLeaf("Rd01");
        assertTrue(root != null);
        assertTrue(ps.getLeaves(root) != null);
        ps.getLeaf("Rd01").split(4, "Rd02", turn);
        ps.getLeaf("Rd01").merge(ps.getLeaf("Rd02"), turn);
        ps.getLeaf("Rd01").split(4, "Rd02", turn);
        cnl.clear();
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        ps.getLeaf("Rd01").addCreature("Troll");
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Rd02").revealCreatures(cnl);
        ps.getLeaf("Rd02").addCreature("Lion");
        assertFalse(ps.getLeaf("Rd01").allCertain());
        assertFalse(ps.getLeaf("Rd02").allCertain());
        ps.printLeaves();

        turn = 2;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Gargoyle");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        ps.getLeaf("Rd01").addCreature("Gargoyle");
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Rd02").revealCreatures(cnl);
        ps.getLeaf("Rd02").addCreature("Lion");
        assertFalse(ps.getLeaf("Rd01").allCertain());
        assertFalse(ps.getLeaf("Rd02").allCertain());
        ps.printLeaves();

        turn = 3;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Titan");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        ps.getLeaf("Rd01").addCreature("Warlock");
        ps.getLeaf("Rd02").addCreature("Gargoyle");
        assertTrue(ps.getLeaf("Rd01").allCertain());
        assertTrue(ps.getLeaf("Rd02").allCertain());
        ps.printLeaves();

        turn = 4;
        Log.debug("Turn " + turn);
        ps.getLeaf("Rd01").split(2, "Rd03", turn);
        ps.getLeaf("Rd02").split(2, "Rd04", turn);
        cnl.clear();
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        ps.getLeaf("Rd01").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        ps.getLeaf("Rd02").revealCreatures(cnl);
        ps.getLeaf("Rd02").addCreature("Cyclops");
        assertFalse(ps.getLeaf("Rd01").allCertain());
        assertFalse(ps.getLeaf("Rd02").allCertain());
        assertFalse(ps.getLeaf("Rd03").allCertain());
        assertFalse(ps.getLeaf("Rd04").allCertain());
        ps.printLeaves();

        turn = 5;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Warlock");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        ps.getLeaf("Rd01").addCreature("Warlock");
        ps.getLeaf("Rd02").addCreature("Ogre");
        cnl.clear();
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps.getLeaf("Rd03").revealCreatures(cnl);
        ps.getLeaf("Rd03").addCreature("Troll");
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Rd04").revealCreatures(cnl);
        ps.getLeaf("Rd04").addCreature("Lion");
        assertTrue(ps.getLeaf("Rd01").allCertain());
        assertTrue(ps.getLeaf("Rd02").allCertain());
        assertTrue(ps.getLeaf("Rd03").allCertain());
        assertTrue(ps.getLeaf("Rd04").allCertain());
        ps.printLeaves();

        turn = 6;
        Log.debug("Turn " + turn);
        ps.getLeaf("Rd02").split(2, "Rd05", turn);
        cnl.clear();
        cnl.add("Titan");
        cnl.add("Warlock");
        cnl.add("Warlock");
        cnl.add("Cyclops");
        cnl.add("Troll");
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        ps.getLeaf("Rd01").removeCreature("Gargoyle");
        ps.getLeaf("Rd01").removeCreature("Gargoyle");
        ps.getLeaf("Rd02").removeCreature("Angel");
        ps.getLeaf("Rd01").addCreature("Angel");
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Lion");
        ps.getLeaf("Rd02").revealCreatures(cnl);
        ps.getLeaf("Rd02").addCreature("Minotaur");
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Rd04").revealCreatures(cnl);
        ps.getLeaf("Rd04").addCreature("Lion");
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Minotaur");
        cnl.add("Lion");
        cnl.add("Lion");
        cnl.add("Ogre");
        ps.getLeaf("Rd02").revealCreatures(cnl);
        ps.getLeaf("Rd02").addCreature("Minotaur");
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Minotaur");
        cnl.add("Minotaur");
        cnl.add("Lion");
        cnl.add("Lion");
        cnl.add("Ogre");
        ps.getLeaf("Rd02").removeCreatures(cnl);
        assertTrue(ps.getLeaf("Rd01").allCertain());
        assertTrue(ps.getLeaf("Rd03").allCertain());
        assertTrue(ps.getLeaf("Rd04").allCertain());
        assertTrue(ps.getLeaf("Rd05").allCertain());
        ps.printLeaves();

        turn = 7;
        Log.debug("Turn " + turn);
        ps.getLeaf("Rd01").addCreature("Angel");
        cnl.clear();
        cnl.add("Troll");
        ps.getLeaf("Rd03").revealCreatures(cnl);
        ps.getLeaf("Rd03").addCreature("Troll");
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Rd04").revealCreatures(cnl);
        ps.getLeaf("Rd04").addCreature("Lion");
        assertTrue(ps.getLeaf("Rd01").allCertain());
        assertTrue(ps.getLeaf("Rd03").allCertain());
        assertTrue(ps.getLeaf("Rd04").allCertain());
        assertTrue(ps.getLeaf("Rd05").allCertain());
        ps.printLeaves();

        turn = 8;
        Log.debug("Turn " + turn);
        ps.getLeaf("Rd01").split(2, "Rd02", turn);
        cnl.clear();
        cnl.add("Cyclops");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        ps.getLeaf("Rd01").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        ps.getLeaf("Rd05").revealCreatures(cnl);
        ps.getLeaf("Rd05").addCreature("Cyclops");
        assertFalse(ps.getLeaf("Rd01").allCertain());
        assertFalse(ps.getLeaf("Rd02").allCertain());
        assertTrue(ps.getLeaf("Rd03").allCertain());
        assertTrue(ps.getLeaf("Rd04").allCertain());
        assertTrue(ps.getLeaf("Rd05").allCertain());
        ps.printLeaves();

        turn = 9;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Troll");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        ps.getLeaf("Rd01").addCreature("Troll");
        cnl.clear();
        cnl.add("Troll");
        ps.getLeaf("Rd03").revealCreatures(cnl);
        ps.getLeaf("Rd03").addCreature("Troll");
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Lion");
        cnl.add("Lion");
        ps.getLeaf("Rd04").revealCreatures(cnl);
        ps.getLeaf("Rd04").addCreature("Griffon");
        cnl.clear();
        cnl.add("Cyclops");
        ps.getLeaf("Rd05").revealCreatures(cnl);
        ps.getLeaf("Rd05").addCreature("Cyclops");
        assertFalse(ps.getLeaf("Rd01").allCertain());
        assertFalse(ps.getLeaf("Rd02").allCertain());
        assertTrue(ps.getLeaf("Rd03").allCertain());
        assertTrue(ps.getLeaf("Rd04").allCertain());
        assertTrue(ps.getLeaf("Rd05").allCertain());
        ps.printLeaves();

        turn = 10;
        Log.debug("Turn " + turn);
        ps.getLeaf("Rd01").split(2, "Rd06", turn);
        assertFalse(ps.getLeaf("Rd01").allCertain());
        assertFalse(ps.getLeaf("Rd02").allCertain());
        assertTrue(ps.getLeaf("Rd03").allCertain());
        assertTrue(ps.getLeaf("Rd04").allCertain());
        assertTrue(ps.getLeaf("Rd05").allCertain());
        assertFalse(ps.getLeaf("Rd06").allCertain());
        ps.printLeaves();

        turn = 11;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Griffon");
        cnl.add("Lion");
        cnl.add("Lion");
        cnl.add("Lion");
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Rd04").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Cyclops");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        ps.getLeaf("Rd01").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Troll");
        cnl.add("Troll");
        ps.getLeaf("Rd03").revealCreatures(cnl);
        ps.getLeaf("Rd03").addCreature("Ranger");
        assertFalse(ps.getLeaf("Rd01").allCertain());
        assertFalse(ps.getLeaf("Rd02").allCertain());
        assertTrue(ps.getLeaf("Rd03").allCertain());
        assertTrue(ps.getLeaf("Rd04").allCertain());
        assertTrue(ps.getLeaf("Rd05").allCertain());
        assertFalse(ps.getLeaf("Rd06").allCertain());
        ps.printLeaves();

        turn = 12;
        Log.debug("Turn " + turn);
        ps.getLeaf("Rd02").addCreature("Centaur");
        cnl.clear();
        cnl.add("Troll");
        cnl.add("Troll");
        ps.getLeaf("Rd03").revealCreatures(cnl);
        ps.getLeaf("Rd03").addCreature("Warbear");
        cnl.clear();
        cnl.add("Cyclops");
        ps.getLeaf("Rd05").revealCreatures(cnl);
        ps.getLeaf("Rd05").addCreature("Cyclops");
        assertFalse(ps.getLeaf("Rd01").allCertain());
        assertFalse(ps.getLeaf("Rd02").allCertain());
        assertTrue(ps.getLeaf("Rd03").allCertain());
        assertTrue(ps.getLeaf("Rd04").allCertain());
        assertTrue(ps.getLeaf("Rd05").allCertain());
        assertFalse(ps.getLeaf("Rd06").allCertain());
        ps.printLeaves();

        turn = 13;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Titan");
        cnl.add("Warlock");
        cnl.add("Warlock");
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        ps.getLeaf("Rd05").revealCreatures(cnl);
        ps.getLeaf("Rd05").addCreature("Behemoth");
        assertTrue(ps.getLeaf("Rd01").allCertain());
        assertTrue(ps.getLeaf("Rd02").allCertain());
        assertTrue(ps.getLeaf("Rd03").allCertain());
        assertTrue(ps.getLeaf("Rd04").allCertain());
        assertTrue(ps.getLeaf("Rd05").allCertain());
        assertTrue(ps.getLeaf("Rd06").allCertain());
        ps.printLeaves();

        turn = 14;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Griffon");
        cnl.add("Lion");
        cnl.add("Lion");
        cnl.add("Lion");
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Rd04").revealCreatures(cnl);
        ps.getLeaf("Rd02").removeCreature("Angel");
        ps.getLeaf("Rd04").addCreature("Angel");
        cnl.clear();
        cnl.add("Angel");
        cnl.add("Lion");
        cnl.add("Lion");
        cnl.add("Lion");
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Rd04").removeCreatures(cnl);
        ps.getLeaf("Rd04").addCreature("Angel");
        assertTrue(ps.getLeaf("Rd01").allCertain());
        assertTrue(ps.getLeaf("Rd02").allCertain());
        assertTrue(ps.getLeaf("Rd03").allCertain());
        assertTrue(ps.getLeaf("Rd04").allCertain());
        assertTrue(ps.getLeaf("Rd05").allCertain());
        assertTrue(ps.getLeaf("Rd06").allCertain());
        ps.printLeaves();

        assertEquals(ps.getLeaf("Rd01").getHeight(), 6);
        assertEquals(ps.getLeaf("Rd02").getHeight(), 2);
        assertEquals(ps.getLeaf("Rd03").getHeight(), 7);
        assertEquals(ps.getLeaf("Rd04").getHeight(), 2);
        assertEquals(ps.getLeaf("Rd05").getHeight(), 6);
        assertEquals(ps.getLeaf("Rd06").getHeight(), 2);
    }

    public void testPredictSplits2()
    {
        Log.debug("testPredictSplits2()");
        ps = new PredictSplits("Red", "Rd11", cnl);

        turn = 1;
        Log.debug("Turn " + turn);
        PredictSplitNode root = ps.getLeaf("Rd11");
        assertTrue(root != null);
        assertTrue(ps.getLeaves(root) != null);
        ps.getLeaf("Rd11").split(4, "Rd10", turn);
        cnl.clear();
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps.getLeaf("Rd10").revealCreatures(cnl);
        ps.getLeaf("Rd10").addCreature("Troll");
        cnl.clear();
        cnl.add("Gargoyle");
        ps.getLeaf("Rd11").revealCreatures(cnl);
        ps.getLeaf("Rd11").addCreature("Gargoyle");
        assertFalse(ps.getLeaf("Rd10").allCertain());
        assertFalse(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 2;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Troll");
        ps.getLeaf("Rd10").revealCreatures(cnl);
        ps.getLeaf("Rd10").addCreature("Troll");
        assertFalse(ps.getLeaf("Rd10").allCertain());
        assertFalse(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 3;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Troll");
        cnl.add("Troll");
        ps.getLeaf("Rd10").revealCreatures(cnl);
        ps.getLeaf("Rd10").addCreature("Ranger");
        cnl.clear();
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        ps.getLeaf("Rd11").addCreature("Cyclops");
        assertFalse(ps.getLeaf("Rd10").allCertain());
        assertFalse(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 4;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Titan");
        cnl.add("Ranger");
        cnl.add("Troll");
        cnl.add("Troll");
        cnl.add("Gargoyle");
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps.getLeaf("Rd10").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Gargoyle");
        ps.getLeaf("Rd10").removeCreatures(cnl);
        cnl.clear();
        cnl.add("Angel");
        ps.getLeaf("Rd11").removeCreatures(cnl);
        ps.getLeaf("Rd10").addCreature("Angel");
        assertTrue(ps.getLeaf("Rd10").allCertain());
        assertTrue(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 5;
        Log.debug("Turn " + turn);
        ps.getLeaf("Rd10").split(2, "Rd01", turn);
        cnl.clear();
        cnl.add("Troll");
        ps.getLeaf("Rd10").revealCreatures(cnl);
        ps.getLeaf("Rd10").addCreature("Troll");
        cnl.clear();
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        ps.getLeaf("Rd01").addCreature("Troll");
        assertTrue(ps.getLeaf("Rd01").allCertain());
        assertTrue(ps.getLeaf("Rd10").allCertain());
        assertTrue(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 6;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Troll");
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Troll");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        ps.getLeaf("Rd01").addCreature("Troll");
        cnl.clear();
        cnl.add("Troll");
        cnl.add("Troll");
        cnl.add("Troll");
        ps.getLeaf("Rd10").revealCreatures(cnl);
        ps.getLeaf("Rd10").addCreature("Wyvern");
        cnl.clear();
        cnl.add("Cyclops");
        ps.getLeaf("Rd11").revealCreatures(cnl);
        ps.getLeaf("Rd11").addCreature("Cyclops");
        assertTrue(ps.getLeaf("Rd01").allCertain());
        assertTrue(ps.getLeaf("Rd10").allCertain());
        assertTrue(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 7;
        Log.debug("Turn " + turn);
        ps.getLeaf("Rd10").split(2, "Rd06", turn);
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Rd11").revealCreatures(cnl);
        ps.getLeaf("Rd11").addCreature("Lion");
        assertTrue(ps.getLeaf("Rd01").allCertain());
        assertFalse(ps.getLeaf("Rd06").allCertain());
        assertFalse(ps.getLeaf("Rd10").allCertain());
        assertTrue(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 8;
        Log.debug("Turn " + turn);
        ps.getLeaf("Rd11").split(2, "Rd07", turn);
        cnl.clear();
        cnl.add("Troll");
        cnl.add("Troll");
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Angel");
        ps.getLeaf("Rd10").removeCreatures(cnl);
        ps.getLeaf("Rd01").addCreature("Angel");
        cnl.clear();
        cnl.add("Troll");
        cnl.add("Troll");
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps.getLeaf("Rd01").removeCreatures(cnl);
        ps.getLeaf("Rd01").addCreature("Angel");
        cnl.clear();
        cnl.add("Wyvern");
        ps.getLeaf("Rd10").revealCreatures(cnl);
        ps.getLeaf("Rd10").addCreature("Wyvern");
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Rd11").revealCreatures(cnl);
        ps.getLeaf("Rd11").addCreature("Lion");
        assertTrue(ps.getLeaf("Rd01").allCertain());
        assertFalse(ps.getLeaf("Rd06").allCertain());
        assertFalse(ps.getLeaf("Rd07").allCertain());
        assertFalse(ps.getLeaf("Rd10").allCertain());
        assertFalse(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 9;
        Log.debug("Turn " + turn);
        ps.getLeaf("Rd07").addCreature("Centaur");
        cnl.clear();
        cnl.add("Cyclops");
        ps.getLeaf("Rd11").revealCreatures(cnl);
        ps.getLeaf("Rd11").addCreature("Cyclops");
        assertTrue(ps.getLeaf("Rd01").allCertain());
        assertFalse(ps.getLeaf("Rd06").allCertain());
        assertFalse(ps.getLeaf("Rd07").allCertain());
        assertFalse(ps.getLeaf("Rd10").allCertain());
        assertFalse(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 10;
        Log.debug("Turn " + turn);
        ps.getLeaf("Rd11").split(2, "Rd08", turn);
        cnl.clear();
        cnl.add("Angel");
        cnl.add("Angel");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Troll");
        cnl.add("Troll");
        ps.getLeaf("Rd06").revealCreatures(cnl);
        ps.getLeaf("Rd06").addCreature("Warbear");
        cnl.clear();
        cnl.add("Centaur");
        ps.getLeaf("Rd07").revealCreatures(cnl);
        ps.getLeaf("Rd07").addCreature("Centaur");
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Rd08").revealCreatures(cnl);
        ps.getLeaf("Rd08").addCreature("Lion");
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Rd10").revealCreatures(cnl);
        ps.getLeaf("Rd10").addCreature("Ranger");
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        ps.getLeaf("Rd11").revealCreatures(cnl);
        ps.getLeaf("Rd11").addCreature("Behemoth");
        cnl.clear();
        cnl.add("Angel");
        cnl.add("Angel");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Angel");
        cnl.add("Angel");
        ps.getLeaf("Rd01").removeCreatures(cnl);
        assertTrue(ps.getLeaf("Rd06").allCertain());
        assertTrue(ps.getLeaf("Rd07").allCertain());
        assertTrue(ps.getLeaf("Rd08").allCertain());
        assertTrue(ps.getLeaf("Rd10").allCertain());
        assertTrue(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 11;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Troll");
        cnl.add("Troll");
        ps.getLeaf("Rd06").revealCreatures(cnl);
        ps.getLeaf("Rd06").addCreature("Ranger");
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Rd07").revealCreatures(cnl);
        ps.getLeaf("Rd07").addCreature("Lion");
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Rd08").revealCreatures(cnl);
        ps.getLeaf("Rd08").addCreature("Lion");
        cnl.clear();
        cnl.add("Titan");
        ps.getLeaf("Rd10").revealCreatures(cnl);
        ps.getLeaf("Rd10").addCreature("Warlock");
        assertTrue(ps.getLeaf("Rd06").allCertain());
        assertTrue(ps.getLeaf("Rd07").allCertain());
        assertTrue(ps.getLeaf("Rd08").allCertain());
        assertTrue(ps.getLeaf("Rd10").allCertain());
        assertTrue(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 12;
        Log.debug("Turn " + turn);
        ps.getLeaf("Rd10").split(2, "Rd05", turn);
        cnl.clear();
        cnl.add("Troll");
        ps.getLeaf("Rd05").revealCreatures(cnl);
        ps.getLeaf("Rd05").addCreature("Troll");
        cnl.clear();
        cnl.add("Troll");
        cnl.add("Troll");
        ps.getLeaf("Rd06").revealCreatures(cnl);
        ps.getLeaf("Rd06").addCreature("Warbear");
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Rd07").revealCreatures(cnl);
        ps.getLeaf("Rd07").addCreature("Lion");
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Lion");
        ps.getLeaf("Rd11").revealCreatures(cnl);
        ps.getLeaf("Rd11").addCreature("Ranger");
        assertFalse(ps.getLeaf("Rd05").allCertain());
        assertTrue(ps.getLeaf("Rd06").allCertain());
        assertTrue(ps.getLeaf("Rd07").allCertain());
        assertTrue(ps.getLeaf("Rd08").allCertain());
        assertFalse(ps.getLeaf("Rd10").allCertain());
        assertTrue(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 13;
        Log.debug("Turn " + turn);
        ps.getLeaf("Rd11").split(2, "Rd04", turn);
        cnl.clear();
        cnl.add("Troll");
        cnl.add("Troll");
        ps.getLeaf("Rd05").revealCreatures(cnl);
        ps.getLeaf("Rd05").addCreature("Warbear");
        cnl.clear();
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        ps.getLeaf("Rd07").revealCreatures(cnl);
        ps.getLeaf("Rd07").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Lion");
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Rd08").revealCreatures(cnl);
        ps.getLeaf("Rd08").removeCreatures(cnl);
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Rd11").revealCreatures(cnl);
        ps.getLeaf("Rd11").addCreature("Ranger");
        assertFalse(ps.getLeaf("Rd04").allCertain());
        assertFalse(ps.getLeaf("Rd05").allCertain());
        assertTrue(ps.getLeaf("Rd06").allCertain());
        assertTrue(ps.getLeaf("Rd07").allCertain());
        assertFalse(ps.getLeaf("Rd10").allCertain());
        assertFalse(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 14;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Warbear");
        cnl.add("Warbear");
        cnl.add("Ranger");
        cnl.add("Troll");
        cnl.add("Troll");
        ps.getLeaf("Rd06").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Cyclops");
        ps.getLeaf("Rd04").revealCreatures(cnl);
        ps.getLeaf("Rd04").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Rd06").revealCreatures(cnl);
        ps.getLeaf("Rd06").addCreature("Ranger");
        cnl.clear();
        cnl.add("Wyvern");
        cnl.add("Wyvern");
        ps.getLeaf("Rd10").revealCreatures(cnl);
        ps.getLeaf("Rd10").addCreature("Hydra");
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Rd11").revealCreatures(cnl);
        ps.getLeaf("Rd11").addCreature("Ranger");
        assertFalse(ps.getLeaf("Rd04").allCertain());
        assertFalse(ps.getLeaf("Rd05").allCertain());
        assertTrue(ps.getLeaf("Rd06").allCertain());
        assertTrue(ps.getLeaf("Rd07").allCertain());
        assertFalse(ps.getLeaf("Rd10").allCertain());
        assertFalse(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 15;
        Log.debug("Turn " + turn);
        ps.getLeaf("Rd07").split(2, "Rd02", turn);
        ps.getLeaf("Rd11").split(2, "Rd01", turn);
        cnl.clear();
        cnl.add("Troll");
        ps.getLeaf("Rd05").revealCreatures(cnl);
        ps.getLeaf("Rd05").addCreature("Troll");
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Rd06").revealCreatures(cnl);
        ps.getLeaf("Rd06").addCreature("Ranger");
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        ps.getLeaf("Rd11").revealCreatures(cnl);
        ps.getLeaf("Rd11").addCreature("Gorgon");
        assertFalse(ps.getLeaf("Rd01").allCertain());
        assertFalse(ps.getLeaf("Rd02").allCertain());
        assertFalse(ps.getLeaf("Rd04").allCertain());
        assertFalse(ps.getLeaf("Rd05").allCertain());
        assertTrue(ps.getLeaf("Rd06").allCertain());
        assertFalse(ps.getLeaf("Rd07").allCertain());
        assertFalse(ps.getLeaf("Rd10").allCertain());
        assertFalse(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 16;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Warbear");
        cnl.add("Warbear");
        cnl.add("Ranger");
        cnl.add("Ranger");
        cnl.add("Ranger");
        cnl.add("Troll");
        cnl.add("Troll");
        ps.getLeaf("Rd06").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        ps.getLeaf("Rd01").addCreature("Ranger");
        cnl.clear();
        cnl.add("Cyclops");
        ps.getLeaf("Rd04").revealCreatures(cnl);
        ps.getLeaf("Rd04").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Rd05").revealCreatures(cnl);
        ps.getLeaf("Rd05").addCreature("Ranger");
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Lion");
        ps.getLeaf("Rd07").revealCreatures(cnl);
        ps.getLeaf("Rd07").addCreature("Ranger");
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Rd10").revealCreatures(cnl);
        ps.getLeaf("Rd10").addCreature("Ranger");
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Rd11").revealCreatures(cnl);
        ps.getLeaf("Rd11").addCreature("Ranger");
        assertFalse(ps.getLeaf("Rd01").allCertain());
        assertFalse(ps.getLeaf("Rd02").allCertain());
        assertFalse(ps.getLeaf("Rd04").allCertain());
        assertTrue(ps.getLeaf("Rd05").allCertain());
        assertTrue(ps.getLeaf("Rd06").allCertain());
        assertFalse(ps.getLeaf("Rd07").allCertain());
        assertTrue(ps.getLeaf("Rd10").allCertain());
        assertFalse(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 17;
        Log.debug("Turn " + turn);
        ps.getLeaf("Rd06").split(2, "Rd08", turn);
        ps.getLeaf("Rd11").split(2, "Rd03", turn);
        cnl.clear();
        cnl.add("Troll");
        cnl.add("Troll");
        ps.getLeaf("Rd08").revealCreatures(cnl);
        ps.getLeaf("Rd08").removeCreatures(cnl);
        cnl.clear();
        cnl.add("Warbear");
        ps.getLeaf("Rd05").revealCreatures(cnl);
        ps.getLeaf("Rd05").addCreature("Warbear");
        cnl.clear();
        cnl.add("Behemoth");
        ps.getLeaf("Rd11").revealCreatures(cnl);
        ps.getLeaf("Rd11").addCreature("Behemoth");
        assertFalse(ps.getLeaf("Rd01").allCertain());
        assertFalse(ps.getLeaf("Rd02").allCertain());
        assertFalse(ps.getLeaf("Rd03").allCertain());
        assertTrue(ps.getLeaf("Rd04").allCertain());
        assertTrue(ps.getLeaf("Rd05").allCertain());
        assertTrue(ps.getLeaf("Rd06").allCertain());
        assertFalse(ps.getLeaf("Rd07").allCertain());
        assertTrue(ps.getLeaf("Rd10").allCertain());
        assertFalse(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 18;
        Log.debug("Turn " + turn);
        ps.getLeaf("Rd10").split(2, "Rd12", turn);
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        ps.getLeaf("Rd01").addCreature("Ranger");
        cnl.clear();
        cnl.add("Gorgon");
        ps.getLeaf("Rd11").revealCreatures(cnl);
        ps.getLeaf("Rd11").addCreature("Gorgon");
        cnl.clear();
        cnl.add("Ranger");
        cnl.add("Ranger");
        ps.getLeaf("Rd12").revealCreatures(cnl);
        ps.getLeaf("Rd12").removeCreatures(cnl);
        assertFalse(ps.getLeaf("Rd01").allCertain());
        assertFalse(ps.getLeaf("Rd02").allCertain());
        assertFalse(ps.getLeaf("Rd03").allCertain());
        assertTrue(ps.getLeaf("Rd04").allCertain());
        assertTrue(ps.getLeaf("Rd05").allCertain());
        assertTrue(ps.getLeaf("Rd06").allCertain());
        assertFalse(ps.getLeaf("Rd07").allCertain());
        assertTrue(ps.getLeaf("Rd10").allCertain());
        assertFalse(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 19;
        Log.debug("Turn " + turn);
        ps.getLeaf("Rd11").split(2, "Rd08", turn);
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Ranger");
        cnl.add("Lion");
        cnl.add("Lion");
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Rd07").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Rd07").removeCreatures(cnl);
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Rd01").revealCreatures(cnl);
        ps.getLeaf("Rd01").addCreature("Ranger");
        cnl.clear();
        cnl.add("Cyclops");
        ps.getLeaf("Rd03").revealCreatures(cnl);
        ps.getLeaf("Rd03").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        ps.getLeaf("Rd04").revealCreatures(cnl);
        ps.getLeaf("Rd04").addCreature("Gorgon");
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Rd07").revealCreatures(cnl);
        ps.getLeaf("Rd07").addCreature("Ranger");
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Rd08").revealCreatures(cnl);
        ps.getLeaf("Rd08").addCreature("Ranger");
        assertFalse(ps.getLeaf("Rd01").allCertain());
        assertTrue(ps.getLeaf("Rd02").allCertain());
        assertFalse(ps.getLeaf("Rd03").allCertain());
        assertTrue(ps.getLeaf("Rd04").allCertain());
        assertTrue(ps.getLeaf("Rd05").allCertain());
        assertTrue(ps.getLeaf("Rd06").allCertain());
        assertTrue(ps.getLeaf("Rd07").allCertain());
        assertFalse(ps.getLeaf("Rd08").allCertain());
        assertTrue(ps.getLeaf("Rd10").allCertain());
        assertFalse(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 20;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Gorgon");
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        cnl.add("Lion");
        ps.getLeaf("Rd04").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Titan");
        cnl.add("Hydra");
        cnl.add("Wyvern");
        cnl.add("Wyvern");
        cnl.add("Warlock");
        ps.getLeaf("Rd10").revealCreatures(cnl);
        ps.getLeaf("Rd10").addCreature("Angel");
        cnl.clear();
        cnl.add("Warbear");
        cnl.add("Warbear");
        cnl.add("Ranger");
        cnl.add("Ranger");
        cnl.add("Troll");
        cnl.add("Troll");
        cnl.add("Troll");
        ps.getLeaf("Rd05").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Troll");
        ps.getLeaf("Rd05").removeCreatures(cnl);
        cnl.clear();
        cnl.add("Angel");
        ps.getLeaf("Rd10").removeCreatures(cnl);
        ps.getLeaf("Rd05").addCreature("Angel");
        cnl.clear();
        cnl.add("Angel");
        cnl.add("Warbear");
        cnl.add("Warbear");
        cnl.add("Ranger");
        cnl.add("Ranger");
        cnl.add("Troll");
        ps.getLeaf("Rd05").removeCreatures(cnl);
        assertFalse(ps.getLeaf("Rd01").allCertain());
        assertTrue(ps.getLeaf("Rd02").allCertain());
        assertFalse(ps.getLeaf("Rd03").allCertain());
        assertTrue(ps.getLeaf("Rd04").allCertain());
        assertTrue(ps.getLeaf("Rd05").allCertain());
        assertTrue(ps.getLeaf("Rd06").allCertain());
        assertTrue(ps.getLeaf("Rd07").allCertain());
        assertFalse(ps.getLeaf("Rd08").allCertain());
        assertTrue(ps.getLeaf("Rd10").allCertain());
        assertFalse(ps.getLeaf("Rd11").allCertain());
        ps.printNodes();
        ps.printLeaves();
    }

    public void testPredictSplits3()
    {
        Log.debug("testPredictSplits3()");
        ps = new PredictSplits("Green", "Gr07", cnl);

        turn = 1;
        Log.debug("Turn " + turn);
        PredictSplitNode root = ps.getLeaf("Gr07");
        assertTrue(root != null);
        assertTrue(ps.getLeaves(root) != null);
        ps.getLeaf("Gr07").split(4, "Gr11", turn);
        cnl.clear();
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        ps.getLeaf("Gr07").revealCreatures(cnl);
        ps.getLeaf("Gr07").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Centaur");
        ps.getLeaf("Gr11").revealCreatures(cnl);
        ps.getLeaf("Gr11").addCreature("Centaur");
        assertFalse(ps.getLeaf("Gr07").allCertain());
        assertFalse(ps.getLeaf("Gr11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 2;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        ps.getLeaf("Gr07").revealCreatures(cnl);
        ps.getLeaf("Gr07").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Ogre");
        ps.getLeaf("Gr11").revealCreatures(cnl);
        ps.getLeaf("Gr11").addCreature("Ogre");
        assertFalse(ps.getLeaf("Gr07").allCertain());
        assertFalse(ps.getLeaf("Gr11").allCertain());
        ps.printNodes();
        ps.printLeaves();

        turn = 3;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Gr11").revealCreatures(cnl);
        ps.getLeaf("Gr11").addCreature("Warbear");
        assertFalse(ps.getLeaf("Gr07").allCertain());
        assertFalse(ps.getLeaf("Gr11").allCertain());
        ps.printNodes();
        ps.printLeaves();
    }

    public void testPredictSplits5()
    {
        Log.debug("testPredictSplits5()");
        ps = new PredictSplits("Gd", "Gd04", cnl);
        cnl.clear();
        cnl.add("Titan");
        cnl.add("Angel");
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        cnl.add("Centaur");
        cnl.add("Centaur");
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps.getLeaf("Gd04").revealCreatures(cnl);
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd04").allCertain());

        turn = 1;
        Log.debug("Turn " + turn);
        ps.getLeaf("Gd04").split(4, "Gd12", turn);
        cnl.clear();
        cnl.add("Titan");
        ps.getLeaf("Gd12").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Centaur");
        ps.getLeaf("Gd04").revealCreatures(cnl);
        ps.getLeaf("Gd04").addCreature("Centaur");
        cnl.clear();
        cnl.add("Titan");
        ps.getLeaf("Gd12").revealCreatures(cnl);
        ps.getLeaf("Gd12").addCreature("Warlock");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd04").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd12").numUncertainCreatures() == 3);

        turn = 2;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps.getLeaf("Gd04").revealCreatures(cnl);
        ps.getLeaf("Gd04").addCreature("Troll");
        cnl.clear();
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        ps.getLeaf("Gd12").revealCreatures(cnl);
        ps.getLeaf("Gd12").addCreature("Cyclops");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd04").allCertain());
        assertTrue(ps.getLeaf("Gd12").allCertain());

        turn = 3;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Gd04").revealCreatures(cnl);
        ps.getLeaf("Gd04").addCreature("Lion");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd04").allCertain());
        assertTrue(ps.getLeaf("Gd12").allCertain());

        turn = 4;
        Log.debug("Turn " + turn);
        ps.getLeaf("Gd04").split(2, "Gd07", turn);
        cnl.clear();
        cnl.add("Troll");
        ps.getLeaf("Gd04").revealCreatures(cnl);
        ps.getLeaf("Gd04").addCreature("Troll");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd04").numUncertainCreatures() == 4);
        assertTrue(ps.getLeaf("Gd07").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd12").allCertain());

        turn = 5;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Gd04").revealCreatures(cnl);
        ps.getLeaf("Gd04").addCreature("Lion");
        cnl.clear();
        cnl.add("Centaur");
        ps.getLeaf("Gd12").revealCreatures(cnl);
        ps.getLeaf("Gd12").addCreature("Centaur");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd04").numUncertainCreatures() == 3);
        assertTrue(ps.getLeaf("Gd07").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd12").allCertain());

        turn = 6;
        Log.debug("Turn " + turn);
        ps.getLeaf("Gd04").split(2, "Gd08", turn);
        ps.getLeaf("Gd12").split(2, "Gd03", turn);
        cnl.clear();
        cnl.add("Ogre");
        ps.getLeaf("Gd08").revealCreatures(cnl);
        ps.getLeaf("Gd08").addCreature("Ogre");
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Gd12").revealCreatures(cnl);
        ps.getLeaf("Gd12").addCreature("Lion");
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Gd07").revealCreatures(cnl);
        ps.getLeaf("Gd07").addCreature("Lion");
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Gd12").revealCreatures(cnl);
        ps.getLeaf("Gd12").addCreature("Lion");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd03").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd04").numUncertainCreatures() == 3);
        assertTrue(ps.getLeaf("Gd07").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd08").numUncertainCreatures() == 1);
        assertTrue(ps.getLeaf("Gd12").numUncertainCreatures() == 3);

        turn = 7;
        Log.debug("Turn " + turn);
        ps.getLeaf("Gd12").split(2, "Gd09", turn);
        cnl.clear();
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        ps.getLeaf("Gd03").revealCreatures(cnl);
        ps.getLeaf("Gd03").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Gd07").revealCreatures(cnl);
        ps.getLeaf("Gd07").addCreature("Lion");
        cnl.clear();
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps.getLeaf("Gd08").revealCreatures(cnl);
        ps.getLeaf("Gd08").addCreature("Troll");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd03").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd04").numUncertainCreatures() == 3);
        assertTrue(ps.getLeaf("Gd07").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd08").numUncertainCreatures() == 1);
        assertTrue(ps.getLeaf("Gd09").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd12").numUncertainCreatures() == 5);

        turn = 8;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Lion");
        ps.getLeaf("Gd04").revealCreatures(cnl);
        ps.getLeaf("Gd04").addCreature("Ranger");
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Lion");
        ps.getLeaf("Gd07").revealCreatures(cnl);
        ps.getLeaf("Gd07").addCreature("Ranger");
        cnl.clear();
        cnl.add("Troll");
        ps.getLeaf("Gd08").revealCreatures(cnl);
        ps.getLeaf("Gd08").addCreature("Troll");
        cnl.clear();
        cnl.add("Cyclops");
        ps.getLeaf("Gd12").revealCreatures(cnl);
        ps.getLeaf("Gd12").addCreature("Cyclops");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd03").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd04").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd07").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd08").numUncertainCreatures() == 1);
        assertTrue(ps.getLeaf("Gd09").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd12").numUncertainCreatures() == 4);

        turn = 10;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Gd07").revealCreatures(cnl);
        ps.getLeaf("Gd07").addCreature("Ranger");
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Lion");
        ps.getLeaf("Gd12").revealCreatures(cnl);
        ps.getLeaf("Gd12").addCreature("Ranger");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd03").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd04").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd07").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd08").numUncertainCreatures() == 1);
        assertTrue(ps.getLeaf("Gd09").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd12").numUncertainCreatures() == 2);

        turn = 11;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Cyclops");
        ps.getLeaf("Gd03").revealCreatures(cnl);
        ps.getLeaf("Gd03").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Lion");
        ps.getLeaf("Gd07").revealCreatures(cnl);
        ps.getLeaf("Gd07").addCreature("Ranger");
        cnl.clear();
        cnl.add("Centaur");
        ps.getLeaf("Gd09").revealCreatures(cnl);
        ps.getLeaf("Gd09").addCreature("Centaur");
        ps.getLeaf("Gd08").removeCreature("Troll");
        ps.getLeaf("Gd08").removeCreature("Troll");
        ps.getLeaf("Gd08").removeCreature("Ogre");
        ps.getLeaf("Gd08").removeCreature("Ogre");
        ps.getLeaf("Gd08").removeCreature("Ogre");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd03").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd04").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd07").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd08") == null);
        assertTrue(ps.getLeaf("Gd09").numUncertainCreatures() == 1);
        assertTrue(ps.getLeaf("Gd12").numUncertainCreatures() == 2);

        turn = 12;
        Log.debug("Turn " + turn);
        ps.getLeaf("Gd07").split(2, "Gd06", turn);
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Gd09").revealCreatures(cnl);
        ps.getLeaf("Gd09").addCreature("Lion");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd03").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd04").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd06").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd07").numUncertainCreatures() == 4);
        assertTrue(ps.getLeaf("Gd09").numUncertainCreatures() == 1);
        assertTrue(ps.getLeaf("Gd12").numUncertainCreatures() == 2);

        turn = 13;
        Log.debug("Turn " + turn);
        ps.getLeaf("Gd12").split(2, "Gd10", turn);
        cnl.clear();
        cnl.add("Cyclops");
        ps.getLeaf("Gd03").revealCreatures(cnl);
        ps.getLeaf("Gd03").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Lion");
        ps.getLeaf("Gd04").revealCreatures(cnl);
        ps.getLeaf("Gd04").addCreature("Ranger");
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        ps.getLeaf("Gd12").revealCreatures(cnl);
        ps.getLeaf("Gd12").addCreature("Gorgon");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd03").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd04").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd06").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd07").numUncertainCreatures() == 4);
        assertTrue(ps.getLeaf("Gd09").numUncertainCreatures() == 1);
        assertTrue(ps.getLeaf("Gd10").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd12").numUncertainCreatures() == 3);

        turn = 14;
        Log.debug("Turn " + turn);
        ps.getLeaf("Gd04").split(2, "Gd02", turn);
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Lion");
        ps.getLeaf("Gd07").revealCreatures(cnl);
        ps.getLeaf("Gd07").addCreature("Minotaur");
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Gd09").revealCreatures(cnl);
        ps.getLeaf("Gd09").addCreature("Warbear");
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Gd10").revealCreatures(cnl);
        ps.getLeaf("Gd10").addCreature("Lion");
        cnl.clear();
        cnl.add("Cyclops");
        ps.getLeaf("Gd12").revealCreatures(cnl);
        ps.getLeaf("Gd12").addCreature("Cyclops");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd02").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd03").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd04").numUncertainCreatures() == 5);
        assertTrue(ps.getLeaf("Gd06").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd07").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd09").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd10").numUncertainCreatures() == 1);
        assertTrue(ps.getLeaf("Gd12").numUncertainCreatures() == 3);

        turn = 15;
        Log.debug("Turn " + turn);
        ps.getLeaf("Gd12").split(2, "Gd11", turn);
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd02").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd03").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd04").numUncertainCreatures() == 5);
        assertTrue(ps.getLeaf("Gd06").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd07").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd09").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd10").numUncertainCreatures() == 1);
        assertTrue(ps.getLeaf("Gd11").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd12").numUncertainCreatures() == 4);

        turn = 16;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Ranger");
        cnl.add("Ranger");
        cnl.add("Ranger");
        cnl.add("Minotaur");
        cnl.add("Lion");
        cnl.add("Lion");
        ps.getLeaf("Gd07").revealCreatures(cnl);
        ps.getLeaf("Gd04").removeCreature("Angel");
        ps.getLeaf("Gd07").addCreature("Angel");
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Lion");
        ps.getLeaf("Gd02").revealCreatures(cnl);
        ps.getLeaf("Gd02").addCreature("Ranger");
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Gd11").revealCreatures(cnl);
        ps.getLeaf("Gd11").addCreature("Ranger");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd02").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd03").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd04").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd06").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd07").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd09").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd10").numUncertainCreatures() == 1);
        assertTrue(ps.getLeaf("Gd11").numUncertainCreatures() == 1);
        assertTrue(ps.getLeaf("Gd12").numUncertainCreatures() == 3);

        turn = 17;
        Log.debug("Turn " + turn);
        ps.getLeaf("Gd07").split(2, "Gd08", turn);
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Gd02").revealCreatures(cnl);
        ps.getLeaf("Gd02").addCreature("Ranger");
        cnl.clear();
        cnl.add("Troll");
        ps.getLeaf("Gd04").revealCreatures(cnl);
        ps.getLeaf("Gd04").addCreature("Troll");
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Gd09").revealCreatures(cnl);
        ps.getLeaf("Gd09").addCreature("Lion");
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Lion");
        cnl.add("Lion");
        ps.getLeaf("Gd10").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Cyclops");
        ps.getLeaf("Gd11").revealCreatures(cnl);
        ps.getLeaf("Gd11").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Angel");
        cnl.add("Ranger");
        cnl.add("Ranger");
        cnl.add("Ranger");
        cnl.add("Minotaur");
        ps.getLeaf("Gd07").revealCreatures(cnl);
        ps.getLeaf("Gd07").removeCreature("Minotaur");
        ps.getLeaf("Gd07").removeCreature("Angel");
        ps.getLeaf("Gd07").removeCreature("Ranger");
        ps.getLeaf("Gd07").removeCreature("Ranger");
        ps.getLeaf("Gd07").removeCreature("Ranger");
        cnl.clear();
        cnl.add("Ranger");
        cnl.add("Ranger");
        cnl.add("Troll");
        cnl.add("Troll");
        cnl.add("Troll");
        ps.getLeaf("Gd04").revealCreatures(cnl);
        ps.getLeaf("Gd04").removeCreature("Ranger");
        ps.getLeaf("Gd04").removeCreature("Ranger");
        ps.getLeaf("Gd04").removeCreature("Troll");
        ps.getLeaf("Gd04").removeCreature("Troll");
        ps.getLeaf("Gd04").removeCreature("Troll");
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Gd02").revealCreatures(cnl);
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd02").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd03").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd04") == null);
        assertTrue(ps.getLeaf("Gd06").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd07") == null);
        assertTrue(ps.getLeaf("Gd08").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd09").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd10").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd11").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd12").numUncertainCreatures() == 0);

        turn = 18;
        Log.debug("Turn " + turn);
        ps.getLeaf("Gd02").addCreature("Lion");
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Lion");
        ps.getLeaf("Gd08").revealCreatures(cnl);
        ps.getLeaf("Gd08").addCreature("Ranger");
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Lion");
        ps.getLeaf("Gd10").revealCreatures(cnl);
        ps.getLeaf("Gd10").addCreature("Ranger");
        ps.getLeaf("Gd06").removeCreature("Centaur");
        ps.getLeaf("Gd06").removeCreature("Centaur");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd02").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd03").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd06") == null);
        assertTrue(ps.getLeaf("Gd08").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd09").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd10").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd11").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd12").numUncertainCreatures() == 0);

        turn = 19;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        ps.getLeaf("Gd03").revealCreatures(cnl);
        ps.getLeaf("Gd03").addCreature("Gorgon");
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Gd10").revealCreatures(cnl);
        ps.getLeaf("Gd10").addCreature("Lion");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd02").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd03").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd08").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd09").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd10").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd11").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd12").numUncertainCreatures() == 0);

        turn = 20;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Lion");
        cnl.add("Lion");
        ps.getLeaf("Gd02").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Gd08").revealCreatures(cnl);
        ps.getLeaf("Gd08").addCreature("Lion");
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Gd09").revealCreatures(cnl);
        ps.getLeaf("Gd09").addCreature("Lion");
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Gd11").revealCreatures(cnl);
        ps.getLeaf("Gd11").addCreature("Troll");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd02").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd03").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd08").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd09").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd10").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd11").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd12").numUncertainCreatures() == 0);

        turn = 22;
        Log.debug("Turn " + turn);
        ps.getLeaf("Gd09").split(2, "Gd07", turn);
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        ps.getLeaf("Gd03").revealCreatures(cnl);
        ps.getLeaf("Gd03").addCreature("Behemoth");
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Gd08").revealCreatures(cnl);
        ps.getLeaf("Gd08").addCreature("Troll");
        cnl.clear();
        cnl.add("Warbear");
        ps.getLeaf("Gd09").revealCreatures(cnl);
        ps.getLeaf("Gd09").addCreature("Warbear");
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Gd10").revealCreatures(cnl);
        ps.getLeaf("Gd10").addCreature("Troll");
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Gd11").revealCreatures(cnl);
        ps.getLeaf("Gd11").addCreature("Lion");
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        ps.getLeaf("Gd12").revealCreatures(cnl);
        ps.getLeaf("Gd12").addCreature("Gorgon");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd02").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd03").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd07").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd08").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd09").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd10").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd11").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd12").numUncertainCreatures() == 0);

        turn = 23;
        Log.debug("Turn " + turn);
        ps.getLeaf("Gd03").split(2, "Gd05", turn);
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Gd02").revealCreatures(cnl);
        ps.getLeaf("Gd02").addCreature("Troll");
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        ps.getLeaf("Gd03").revealCreatures(cnl);
        ps.getLeaf("Gd03").addCreature("Gorgon");
        cnl.clear();
        cnl.add("Centaur");
        ps.getLeaf("Gd07").revealCreatures(cnl);
        ps.getLeaf("Gd07").addCreature("Centaur");
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Gd08").revealCreatures(cnl);
        ps.getLeaf("Gd08").addCreature("Lion");
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Gd11").revealCreatures(cnl);
        ps.getLeaf("Gd11").addCreature("Lion");
        cnl.clear();
        cnl.add("Cyclops");
        ps.getLeaf("Gd12").revealCreatures(cnl);
        ps.getLeaf("Gd12").addCreature("Cyclops");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd02").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd03").numUncertainCreatures() == 3);
        assertTrue(ps.getLeaf("Gd05").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd07").numUncertainCreatures() == 1);
        assertTrue(ps.getLeaf("Gd08").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd09").numUncertainCreatures() == 1);
        assertTrue(ps.getLeaf("Gd10").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd11").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd12").numUncertainCreatures() == 0);

        turn = 24;
        Log.debug("Turn " + turn);
        ps.getLeaf("Gd02").split(2, "Gd04", turn);
        ps.getLeaf("Gd10").split(2, "Gd06", turn);
        cnl.clear();
        cnl.add("Ranger");
        ps.getLeaf("Gd02").revealCreatures(cnl);
        ps.getLeaf("Gd02").addCreature("Troll");
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        ps.getLeaf("Gd03").revealCreatures(cnl);
        ps.getLeaf("Gd03").addCreature("Behemoth");
        cnl.clear();
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        ps.getLeaf("Gd05").revealCreatures(cnl);
        ps.getLeaf("Gd05").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Gd08").revealCreatures(cnl);
        ps.getLeaf("Gd08").addCreature("Centaur");
        ps.printLeaves();
        assertTrue(ps.getLeaf("Gd02").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd03").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd04").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd05").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd06").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd07").numUncertainCreatures() == 1);
        assertTrue(ps.getLeaf("Gd08").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd09").numUncertainCreatures() == 1);
        assertTrue(ps.getLeaf("Gd10").numUncertainCreatures() == 2);
        assertTrue(ps.getLeaf("Gd11").numUncertainCreatures() == 0);
        assertTrue(ps.getLeaf("Gd12").numUncertainCreatures() == 0);
    }


    public void testPredictSplits6()
    {
        Log.debug("testPredictSplits6()");
        ps = new PredictSplits("Gr", "Gr11", cnl);
        aps.add(ps);

        turn = 1;
        cnl.clear();
        cnl.add("Titan");
        cnl.add("Angel");
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        cnl.add("Centaur");
        cnl.add("Centaur");
        cnl.add("Ogre");
        cnl.add("Ogre");
        aps.getLeaf("Gr11").revealCreatures(cnl);
        aps.getLeaf("Gr11").split(4, "Gr02", turn);
        cnl.clear();
        cnl.add("Titan");
        aps.getLeaf("Gr02").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        aps.getLeaf("Gr02").revealCreatures(cnl);
        aps.getLeaf("Gr02").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Centaur");
        aps.getLeaf("Gr11").revealCreatures(cnl);
        aps.getLeaf("Gr11").addCreature("Centaur");
        aps.printLeaves();
        assertEquals(ps.getLeaf("Gr02").numUncertainCreatures(), 1);
        assertEquals(ps.getLeaf("Gr11").numUncertainCreatures(), 1);

        turn = 2;
        cnl.clear();
        cnl.add("Titan");
        aps.getLeaf("Gr02").revealCreatures(cnl);
        aps.getLeaf("Gr02").addCreature("Warlock");
        cnl.clear();
        cnl.add("Centaur");
        aps.getLeaf("Gr11").revealCreatures(cnl);
        aps.getLeaf("Gr11").addCreature("Centaur");
        assertFalse(ps.getLeaf("Gr02").allCertain());
        assertFalse(ps.getLeaf("Gr11").allCertain());
        aps.printLeaves();
        assertEquals(ps.getLeaf("Gr02").numUncertainCreatures(), 1);
        assertEquals(ps.getLeaf("Gr11").numUncertainCreatures(), 1);

        turn = 3;
        cnl.clear();
        cnl.add("Cyclops");
        aps.getLeaf("Gr02").revealCreatures(cnl);
        aps.getLeaf("Gr02").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        aps.getLeaf("Gr11").revealCreatures(cnl);
        aps.getLeaf("Gr11").addCreature("Lion");
        aps.printLeaves();
        assertEquals(ps.getLeaf("Gr02").numUncertainCreatures(), 1);
        assertEquals(ps.getLeaf("Gr11").numUncertainCreatures(), 1);

        turn = 4;
        aps.getLeaf("Gr02").split(2, "Gr10", turn);
        aps.getLeaf("Gr11").split(3, "Gr03", turn);
        aps.getLeaf("Gr11").merge(ps.getLeaf("Gr03"), turn);
        aps.printLeaves();
        assertEquals(ps.getLeaf("Gr02").numUncertainCreatures(), 5);
        assertEquals(ps.getLeaf("Gr10").numUncertainCreatures(), 2);
        assertEquals(ps.getLeaf("Gr11").numUncertainCreatures(), 1);

        turn = 5;
        aps.getLeaf("Gr11").split(3, "Gr12", turn);
        cnl.clear();
        cnl.add("Warlock");
        aps.getLeaf("Gr02").revealCreatures(cnl);
        aps.getLeaf("Gr02").addCreature("Warlock");
        cnl.clear();
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        aps.getLeaf("Gr10").revealCreatures(cnl);
        aps.getLeaf("Gr10").addCreature("Cyclops");
        aps.printLeaves();
        assertEquals(ps.getLeaf("Gr02").numUncertainCreatures(), 1);
        assertEquals(ps.getLeaf("Gr10").numUncertainCreatures(), 0);
        assertEquals(ps.getLeaf("Gr11").numUncertainCreatures(), 4);
        assertEquals(ps.getLeaf("Gr12").numUncertainCreatures(), 3);

        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        cnl.add("Centaur");
        aps.getLeaf("Gr12").revealCreatures(cnl);
        aps.getLeaf("Gr12").addCreature("Warbear");
        aps.printLeaves();
        assertEquals(ps.getLeaf("Gr02").numUncertainCreatures(), 1);
        assertEquals(ps.getLeaf("Gr10").numUncertainCreatures(), 0);
        assertEquals(ps.getLeaf("Gr11").numUncertainCreatures(), 1);
        assertEquals(ps.getLeaf("Gr12").numUncertainCreatures(), 0);

        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        aps.getLeaf("Gr10").revealCreatures(cnl);
        aps.getLeaf("Gr10").removeCreature("Cyclops");
        cnl.clear();
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        aps.getLeaf("Gr10").revealCreatures(cnl);
        aps.getLeaf("Gr10").addCreature("Cyclops");
        aps.getLeaf("Gr10").removeCreature("Cyclops");
        aps.getLeaf("Gr10").removeCreature("Gargoyle");
        aps.getLeaf("Gr10").removeCreature("Gargoyle");
        aps.printLeaves();
        assertFalse(ps.getLeaf("Gr02").allCertain());
        assertFalse(ps.getLeaf("Gr11").allCertain());
        assertTrue(ps.getLeaf("Gr12").allCertain());

        turn = 6;
        cnl.clear();
        cnl.add("Centaur");
        aps.getLeaf("Gr02").revealCreatures(cnl);
        aps.getLeaf("Gr02").addCreature("Centaur");
        aps.printLeaves();
        assertTrue(ps.getLeaf("Gr02").allCertain());
        assertTrue(ps.getLeaf("Gr11").allCertain());
        assertTrue(ps.getLeaf("Gr12").allCertain());
    }

    public void testPredictSplits7()
    {
        Log.debug("testPredictSplits7()");
        ps = new PredictSplits("Gr", "Gr08", cnl);
        aps.add(ps);
        aps.printLeaves();

        turn = 1;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gr08").split(4, "Gr04", turn);
        cnl.clear();
        cnl.add("Titan");
        aps.getLeaf("Gr04").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Titan");
        aps.getLeaf("Gr04").revealCreatures(cnl);
        aps.getLeaf("Gr04").addCreature("Warlock");
        cnl.clear();
        cnl.add("Centaur");
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Centaur");
        aps.printLeaves();
        assertFalse(ps.getLeaf("Gr04").allCertain());
        assertFalse(ps.getLeaf("Gr08").allCertain());

        turn = 2;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Gargoyle");
        aps.getLeaf("Gr04").revealCreatures(cnl);
        aps.getLeaf("Gr04").addCreature("Gargoyle");
        aps.printLeaves();
        assertFalse(ps.getLeaf("Gr04").allCertain());
        assertFalse(ps.getLeaf("Gr08").allCertain());

        turn = 3;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        aps.getLeaf("Gr04").revealCreatures(cnl);
        aps.getLeaf("Gr04").addCreature("Cyclops");
        aps.printLeaves();
        assertFalse(ps.getLeaf("Gr04").allCertain());
        assertFalse(ps.getLeaf("Gr08").allCertain());

        turn = 4;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gr04").split(2, "Gr06", turn);
        cnl.clear();
        cnl.add("Ogre");
        aps.getLeaf("Gr04").revealCreatures(cnl);
        aps.getLeaf("Gr04").addCreature("Ogre");
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Lion");
        aps.printLeaves();
        assertFalse(ps.getLeaf("Gr04").allCertain());
        assertFalse(ps.getLeaf("Gr06").allCertain());
        assertFalse(ps.getLeaf("Gr08").allCertain());

        turn = 5;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Cyclops");
        aps.getLeaf("Gr04").revealCreatures(cnl);
        aps.getLeaf("Gr04").addCreature("Cyclops");
        aps.getLeaf("Gr06").addCreature("Ogre");
        cnl.clear();
        cnl.add("Lion");
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Lion");
        aps.printLeaves();
        assertFalse(ps.getLeaf("Gr04").allCertain());
        assertFalse(ps.getLeaf("Gr06").allCertain());
        assertFalse(ps.getLeaf("Gr08").allCertain());
        assertEquals(ps.getLeaf("Gr06").numCertainCreatures(), 1);

        turn = 6;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gr04").split(2, "Gr07", turn);
        aps.getLeaf("Gr08").split(2, "Gr11", turn);
        cnl.clear();
        cnl.add("Titan");
        aps.getLeaf("Gr04").revealCreatures(cnl);
        aps.getLeaf("Gr04").addCreature("Warlock");
        cnl.clear();
        cnl.add("Ogre");
        aps.getLeaf("Gr06").revealCreatures(cnl);
        aps.getLeaf("Gr06").addCreature("Ogre");
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        aps.getLeaf("Gr11").removeCreatures(cnl);
        aps.printLeaves();
        assertFalse(ps.getLeaf("Gr04").allCertain());
        assertFalse(ps.getLeaf("Gr06").allCertain());
        assertFalse(ps.getLeaf("Gr07").allCertain());
        assertFalse(ps.getLeaf("Gr08").allCertain());

        turn = 7;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Cyclops");
        aps.getLeaf("Gr04").revealCreatures(cnl);
        aps.getLeaf("Gr04").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Ogre");
        cnl.add("Ogre");
        aps.getLeaf("Gr06").revealCreatures(cnl);
        aps.getLeaf("Gr06").addCreature("Troll");
        cnl.clear();
        cnl.add("Ogre");
        aps.getLeaf("Gr07").revealCreatures(cnl);
        aps.getLeaf("Gr07").addCreature("Ogre");
        aps.printLeaves();
        assertFalse(ps.getLeaf("Gr04").allCertain());
        assertFalse(ps.getLeaf("Gr06").allCertain());
        assertFalse(ps.getLeaf("Gr07").allCertain());
        assertFalse(ps.getLeaf("Gr08").allCertain());

        turn = 8;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gr04").split(2, "Gr12", turn);
        cnl.clear();
        cnl.add("Ogre");
        cnl.add("Ogre");
        cnl.add("Ogre");
        aps.getLeaf("Gr07").revealCreatures(cnl);
        aps.getLeaf("Gr07").addCreature("Minotaur");
        cnl.clear();
        cnl.add("Gargoyle");
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Gargoyle");
        cnl.clear();
        cnl.add("Troll");
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        cnl.add("Ogre");
        cnl.add("Ogre");
        aps.getLeaf("Gr06").removeCreatures(cnl);
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Ogre");
        aps.getLeaf("Gr12").removeCreatures(cnl);
        aps.printLeaves();
        assertTrue(ps.getLeaf("Gr04").allCertain());
        assertTrue(ps.getLeaf("Gr07").allCertain());
        assertTrue(ps.getLeaf("Gr08").allCertain());

        turn = 9;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Cyclops");
        aps.printLeaves();
        assertTrue(ps.getLeaf("Gr04").allCertain());
        assertTrue(ps.getLeaf("Gr07").allCertain());
        assertTrue(ps.getLeaf("Gr08").allCertain());

        turn = 11;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gr08").split(2, "Gr01", turn);
        cnl.clear();
        cnl.add("Titan");
        aps.getLeaf("Gr04").revealCreatures(cnl);
        aps.getLeaf("Gr04").addCreature("Warlock");
        cnl.clear();
        cnl.add("Cyclops");
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Cyclops");
        aps.printLeaves();
        assertFalse(ps.getLeaf("Gr01").allCertain());
        assertTrue(ps.getLeaf("Gr04").allCertain());
        assertTrue(ps.getLeaf("Gr07").allCertain());
        assertFalse(ps.getLeaf("Gr08").allCertain());

        turn = 12;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Cyclops");
        aps.getLeaf("Gr04").revealCreatures(cnl);
        aps.getLeaf("Gr04").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Lion");
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Lion");
        aps.printLeaves();
        aps.getLeaf("Gr01").removeCreature("Gargoyle");
        aps.getLeaf("Gr01").removeCreature("Gargoyle");
        aps.printLeaves();
        assertTrue(ps.getLeaf("Gr04").allCertain());
        assertTrue(ps.getLeaf("Gr07").allCertain());
        assertTrue(ps.getLeaf("Gr08").allCertain());

        turn = 13;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gr08").split(2, "Gr02", turn);
        cnl.clear();
        cnl.add("Ogre");
        cnl.add("Ogre");
        aps.getLeaf("Gr07").revealCreatures(cnl);
        aps.getLeaf("Gr07").addCreature("Troll");
        aps.printLeaves();
        assertFalse(ps.getLeaf("Gr02").allCertain());
        assertTrue(ps.getLeaf("Gr04").allCertain());
        assertTrue(ps.getLeaf("Gr07").allCertain());
        assertFalse(ps.getLeaf("Gr08").allCertain());

        turn = 14;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gr04").split(2, "Gr06", turn);
        cnl.clear();
        cnl.add("Cyclops");
        aps.getLeaf("Gr04").revealCreatures(cnl);
        aps.getLeaf("Gr04").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Cyclops");
        aps.getLeaf("Gr06").revealCreatures(cnl);
        aps.getLeaf("Gr06").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Cyclops");
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Cyclops");
        aps.printLeaves();
        assertFalse(ps.getLeaf("Gr02").allCertain());
        assertFalse(ps.getLeaf("Gr04").allCertain());
        assertFalse(ps.getLeaf("Gr06").allCertain());
        assertTrue(ps.getLeaf("Gr07").allCertain());
        assertFalse(ps.getLeaf("Gr08").allCertain());

        turn = 15;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gr06").removeCreature("Cyclops");
        aps.getLeaf("Gr06").removeCreature("Cyclops");
        aps.getLeaf("Gr06").removeCreature("Cyclops");
        cnl.clear();
        cnl.add("Centaur");
        aps.getLeaf("Gr02").revealCreatures(cnl);
        aps.getLeaf("Gr02").addCreature("Centaur");
        aps.printLeaves();
        assertFalse(ps.getLeaf("Gr02").allCertain());
        assertTrue(ps.getLeaf("Gr04").allCertain());
        assertTrue(ps.getLeaf("Gr07").allCertain());
        assertFalse(ps.getLeaf("Gr08").allCertain());

        turn = 16;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Cyclops");
        aps.getLeaf("Gr04").revealCreatures(cnl);
        aps.getLeaf("Gr04").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Ogre");
        cnl.add("Ogre");
        cnl.add("Ogre");
        aps.getLeaf("Gr07").revealCreatures(cnl);
        aps.getLeaf("Gr07").addCreature("Minotaur");
        cnl.clear();
        cnl.add("Lion");
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Lion");
        aps.printLeaves();
        assertFalse(ps.getLeaf("Gr02").allCertain());
        assertTrue(ps.getLeaf("Gr04").allCertain());
        assertTrue(ps.getLeaf("Gr07").allCertain());
        assertFalse(ps.getLeaf("Gr08").allCertain());

        turn = 17;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Centaur");
        cnl.add("Centaur");
        aps.getLeaf("Gr02").revealCreatures(cnl);
        aps.getLeaf("Gr02").removeCreature("Centaur");
        aps.getLeaf("Gr02").removeCreature("Lion");
        aps.getLeaf("Gr02").removeCreature("Centaur");
        aps.printLeaves();
        aps.getLeaf("Gr08").split(2, "Gr12", turn);
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Gorgon");
        aps.printLeaves();
        assertTrue(ps.getLeaf("Gr04").allCertain());
        assertTrue(ps.getLeaf("Gr07").allCertain());
        assertFalse(ps.getLeaf("Gr08").allCertain());
        assertFalse(ps.getLeaf("Gr12").allCertain());

        turn = 18;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gr12").removeCreature("Lion");
        aps.getLeaf("Gr12").removeCreature("Lion");
        aps.getLeaf("Gr04").split(2, "Gr12", turn);
        aps.getLeaf("Gr07").split(2, "Gr09", turn);
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Gorgon");
        aps.printLeaves();
        assertFalse(ps.getLeaf("Gr04").allCertain());
        assertFalse(ps.getLeaf("Gr07").allCertain());
        assertTrue(ps.getLeaf("Gr08").allCertain());
        assertFalse(ps.getLeaf("Gr09").allCertain());
        assertFalse(ps.getLeaf("Gr12").allCertain());

        turn = 19;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gr08").split(2, "Gr06", turn);
        aps.getLeaf("Gr09").removeCreature("Ogre");
        aps.getLeaf("Gr09").removeCreature("Ogre");
        cnl.clear();
        cnl.add("Minotaur");
        cnl.add("Minotaur");
        aps.getLeaf("Gr07").revealCreatures(cnl);
        aps.getLeaf("Gr07").addCreature("Unicorn");
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Gorgon");
        aps.printLeaves();
        assertFalse(ps.getLeaf("Gr04").allCertain());
        assertFalse(ps.getLeaf("Gr06").allCertain());
        assertTrue(ps.getLeaf("Gr07").allCertain());
        assertFalse(ps.getLeaf("Gr08").allCertain());
        assertFalse(ps.getLeaf("Gr12").allCertain());

        turn = 20;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gr06").removeCreature("Gorgon");
        aps.getLeaf("Gr06").removeCreature("Lion");
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Behemoth");
        cnl.clear();
        cnl.add("Cyclops");
        aps.getLeaf("Gr12").revealCreatures(cnl);
        aps.getLeaf("Gr12").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Cyclops");
        aps.printLeaves();
        assertFalse(ps.getLeaf("Gr04").allCertain());
        assertTrue(ps.getLeaf("Gr07").allCertain());
        assertTrue(ps.getLeaf("Gr08").allCertain());
        assertFalse(ps.getLeaf("Gr12").allCertain());

        turn = 21;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gr04").revealCreatures(cnl);
        aps.getLeaf("Gr04").addCreature("Gargoyle");
        cnl.clear();
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        cnl.add("Cyclops");
        aps.getLeaf("Gr12").revealCreatures(cnl);
        aps.getLeaf("Gr12").addCreature("Behemoth");
        aps.printLeaves();
        assertTrue(ps.getLeaf("Gr04").allCertain());
        assertTrue(ps.getLeaf("Gr07").allCertain());
        assertTrue(ps.getLeaf("Gr08").allCertain());
        assertTrue(ps.getLeaf("Gr12").allCertain());
    }

    public void testPredictSplits9()
    {
        aps.add(new PredictSplits("Gd", "Gd08", cnl));
        aps.add(new PredictSplits("Bu", "Bu02", cnl));
        aps.add(new PredictSplits("Gr", "Gr12", cnl));
        aps.add(new PredictSplits("Br", "Br06", cnl));
        aps.add(new PredictSplits("Bk", "Bk06", cnl));
        aps.add(new PredictSplits("Rd", "Rd06", cnl));

        aps.printLeaves();
        turn = 1;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd08").split(4, "Gd03", turn);
        cnl.clear();
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Gd08").revealCreatures(cnl);
        aps.getLeaf("Gd08").addCreature("Ogre");
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Gd08").numUncertainCreatures(), 2);
        aps.getLeaf("Bu02").split(4, "Bu05", turn);
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Bu02").revealCreatures(cnl);
        aps.getLeaf("Bu02").addCreature("Centaur");
        cnl.clear();
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Bu05").revealCreatures(cnl);
        aps.getLeaf("Bu05").addCreature("Cyclops");
        assertEquals(aps.getLeaf("Bu02").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Bu05").numUncertainCreatures(), 2);
        aps.getLeaf("Gr12").split(4, "Gr08", turn);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Gr08").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Troll");
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Gr12").revealCreatures(cnl);
        aps.getLeaf("Gr12").addCreature("Centaur");
        assertEquals(aps.getLeaf("Gr08").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gr12").numUncertainCreatures(), 1);
        aps.getLeaf("Br06").split(4, "Br01", turn);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Br06").revealCreatures(cnl);
        aps.getLeaf("Br06").addCreature("Centaur");
        assertEquals(aps.getLeaf("Br01").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Br06").numUncertainCreatures(), 1);
        aps.getLeaf("Bk06").split(4, "Bk10", turn);
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Ogre");
        cnl.clear();
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Cyclops");
        assertEquals(aps.getLeaf("Bk06").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Bk10").numUncertainCreatures(), 2);
        aps.getLeaf("Rd06").split(4, "Rd02", turn);
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Rd02").revealCreatures(cnl);
        aps.getLeaf("Rd02").addCreature("Ogre");
        assertEquals(aps.getLeaf("Rd02").numUncertainCreatures(), 3);
        assertEquals(aps.getLeaf("Rd06").numUncertainCreatures(), 4);
        aps.printLeaves();

        turn = 2;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Cyclops");
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Gd08").numUncertainCreatures(), 2);
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Bu02").revealCreatures(cnl);
        aps.getLeaf("Bu02").addCreature("Centaur");
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Bu05").revealCreatures(cnl);
        aps.getLeaf("Bu05").addCreature("Cyclops");
        assertEquals(aps.getLeaf("Bu02").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Bu05").numUncertainCreatures(), 2);
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Troll");
        cnl.clear();
        cnl.add("Gargoyle"); 
        aps.getLeaf("Gr12").revealCreatures(cnl);
        aps.getLeaf("Gr12").addCreature("Gargoyle");
        assertEquals(aps.getLeaf("Gr08").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gr12").numUncertainCreatures(), 1);
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Br06").revealCreatures(cnl);
        aps.getLeaf("Br06").addCreature("Lion");
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Centaur");
        assertEquals(aps.getLeaf("Br01").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Br06").numUncertainCreatures(), 1);
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Ogre");
        assertEquals(aps.getLeaf("Bk06").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Bk10").numUncertainCreatures(), 1);
        aps.printLeaves();

        turn = 3;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Gd08").revealCreatures(cnl);
        aps.getLeaf("Gd08").addCreature("Guardian");
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gd08").numUncertainCreatures(), 1);
        cnl.clear();
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Bu02").revealCreatures(cnl);
        aps.getLeaf("Bu02").addCreature("Troll");
        assertEquals(aps.getLeaf("Bu02").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Bu05").numUncertainCreatures(), 1);
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Ogre");
        cnl.clear();
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Gr12").revealCreatures(cnl);
        aps.getLeaf("Gr12").addCreature("Cyclops");
        assertEquals(aps.getLeaf("Gr08").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gr12").numUncertainCreatures(), 1);
        aps.printLeaves();
        aps.getLeaf("Br06").split(3, "Br12", turn);
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Lion"); 
        aps.getLeaf("Br06").revealCreatures(cnl);
        aps.getLeaf("Br06").addCreature("Lion");
        assertEquals(aps.getLeaf("Br01").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Br06").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Br12").numUncertainCreatures(), 3);
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Lion");
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Cyclops");
        assertEquals(aps.getLeaf("Bk06").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Bk10").numUncertainCreatures(), 1);
        cnl.clear();
        cnl.add("Gargoyle"); 
        aps.getLeaf("Rd06").revealCreatures(cnl);
        aps.getLeaf("Rd06").addCreature("Gargoyle");
        assertEquals(aps.getLeaf("Rd02").numUncertainCreatures(), 3);
        assertEquals(aps.getLeaf("Rd06").numUncertainCreatures(), 3);
        aps.printLeaves();
        turn = 4;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd12", turn);
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Centaur");
        cnl.clear();
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Gd12").revealCreatures(cnl);
        aps.getLeaf("Gd12").addCreature("Cyclops");
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gd08").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 0);
        aps.getLeaf("Bu02").split(2, "Bu08", turn);
        aps.getLeaf("Bu02").merge(aps.getLeaf("Bu08"), turn);
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Bu05").revealCreatures(cnl);
        aps.getLeaf("Bu05").addCreature("Cyclops");
        aps.getLeaf("Gr08").split(2, "Gr06", turn);
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr06"), turn);
        aps.getLeaf("Gr12").split(2, "Gr09", turn);
        cnl.clear();
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Gr09").revealCreatures(cnl);
        aps.getLeaf("Gr09").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").addCreature("Ogre");
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Warbear");
        aps.getLeaf("Bk06").split(2, "Bk04", turn);
        aps.getLeaf("Bk10").split(2, "Bk11", turn);
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Centaur");
        aps.getLeaf("Bk11").removeCreature("Gargoyle");
        aps.getLeaf("Bk11").removeCreature("Gargoyle");
        cnl.clear();
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Rd06").revealCreatures(cnl);
        aps.getLeaf("Rd06").addCreature("Cyclops");
        aps.printLeaves();

        turn = 5;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Lion");
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gd08").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 0);
        aps.getLeaf("Bu02").split(2, "Bu01", turn);
        aps.getLeaf("Bu05").split(2, "Bu09", turn);
        cnl.clear();
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Bu09").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Warbear"); 
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").removeCreature("Centaur");
        aps.getLeaf("Bu09").removeCreature("Gargoyle");
        aps.getLeaf("Bu09").removeCreature("Gargoyle");
        cnl.clear();
        cnl.add("Warbear"); 
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Warbear"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Warbear");
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Bu05").revealCreatures(cnl);
        aps.getLeaf("Bu05").addCreature("Gorgon");
        aps.getLeaf("Gr08").split(2, "Gr01", turn);
        cnl.clear();
        cnl.add("Gargoyle"); 
        aps.getLeaf("Gr01").revealCreatures(cnl);
        aps.getLeaf("Gr01").addCreature("Gargoyle");
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Gr09").revealCreatures(cnl);
        aps.getLeaf("Gr09").addCreature("Cyclops");
        aps.getLeaf("Br01").split(2, "Br11", turn);
        aps.getLeaf("Br01").merge(aps.getLeaf("Br11"), turn);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Warlock");
        aps.printLeaves();
        turn = 6;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd06", turn);
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Behemoth");
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Lion");
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Gd12").revealCreatures(cnl);
        aps.getLeaf("Gd12").addCreature("Cyclops");
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gd06").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gd08").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 0);
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Bu02").revealCreatures(cnl);
        aps.getLeaf("Bu02").addCreature("Troll");
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Bu05").revealCreatures(cnl);
        aps.getLeaf("Bu05").addCreature("Warlock");
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Gr01").revealCreatures(cnl);
        aps.getLeaf("Gr01").addCreature("Ogre");
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Gr09").revealCreatures(cnl);
        aps.getLeaf("Gr09").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Gr12").revealCreatures(cnl);
        aps.getLeaf("Gr12").addCreature("Lion");
        aps.getLeaf("Br01").split(2, "Br09", turn);
        aps.getLeaf("Br01").merge(aps.getLeaf("Br09"), turn);
        cnl.clear();
        cnl.add("Lion"); 
        aps.getLeaf("Br06").revealCreatures(cnl);
        aps.getLeaf("Br06").addCreature("Lion");
        cnl.clear();
        cnl.add("Warbear"); 
        cnl.add("Warbear"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Unicorn");
        cnl.clear();
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Troll");
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Rd06").revealCreatures(cnl);
        aps.getLeaf("Rd06").addCreature("Cyclops");
        aps.printLeaves();

        turn = 7;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Lion"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Lion");
        cnl.clear();
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Gd08").revealCreatures(cnl);
        aps.getLeaf("Gd08").addCreature("Troll");
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Gd12").revealCreatures(cnl);
        aps.getLeaf("Gd12").addCreature("Cyclops");
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gd06").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gd08").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 0);
        aps.getLeaf("Bu05").split(2, "Bu12", turn);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Bu05").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Bu02").revealCreatures(cnl);
        aps.getLeaf("Bu02").addCreature("Troll");
        cnl.clear();
        cnl.add("Warlock"); 
        aps.getLeaf("Bu05").revealCreatures(cnl);
        aps.getLeaf("Bu05").addCreature("Warlock");
        aps.getLeaf("Gr12").split(3, "Gr02", turn);
        aps.getLeaf("Gr12").merge(aps.getLeaf("Gr02"), turn);
        cnl.clear();
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Gr01").revealCreatures(cnl);
        aps.getLeaf("Gr01").addCreature("Cyclops");
        aps.getLeaf("Br01").split(2, "Br08", turn);
        aps.getLeaf("Br01").merge(aps.getLeaf("Br08"), turn);
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Br06").revealCreatures(cnl);
        aps.getLeaf("Br06").addCreature("Ogre");
        cnl.clear();
        cnl.add("Unicorn"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Unicorn");
        aps.getLeaf("Bk06").split(2, "Bk12", turn);
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Bk04").revealCreatures(cnl);
        aps.getLeaf("Bk04").addCreature("Lion");
        cnl.clear();
        cnl.add("Lion"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Lion");
        aps.printLeaves();

        turn = 8;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd04", turn);
        aps.getLeaf("Gd08").split(2, "Gd05", turn);
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Gorgon");
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Gd05").revealCreatures(cnl);
        aps.getLeaf("Gd05").addCreature("Centaur");
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 3);
        assertEquals(aps.getLeaf("Gd04").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Gd05").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gd06").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gd08").numUncertainCreatures(), 3);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 0);
        aps.getLeaf("Bu02").split(2, "Bu07", turn);
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Bu07").revealCreatures(cnl);
        aps.getLeaf("Bu07").addCreature("Centaur");
        aps.getLeaf("Gr12").split(3, "Gr03", turn);
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Gr01").revealCreatures(cnl);
        aps.getLeaf("Gr01").addCreature("Cyclops");
        aps.getLeaf("Br01").split(2, "Br09", turn);
        cnl.clear();
        cnl.add("Lion"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Lion");
        aps.getLeaf("Bk12").addCreature("Centaur");
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Rd06").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Angel"); 
        cnl.add("Guardian"); 
        cnl.add("Troll"); 
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Gd08").revealCreatures(cnl);
        aps.getLeaf("Gd08").removeCreature("Ogre");
        aps.getLeaf("Rd06").removeCreature("Gargoyle");
        aps.getLeaf("Rd02").removeCreature("Angel");
        aps.getLeaf("Rd06").addCreature("Angel");
        aps.getLeaf("Rd06").removeCreature("Centaur");
        aps.getLeaf("Gd08").removeCreature("Angel");
        aps.getLeaf("Gd08").removeCreature("Troll");
        aps.getLeaf("Rd06").removeCreature("Angel");
        aps.getLeaf("Gd08").removeCreature("Ogre");
        aps.getLeaf("Gd08").removeCreature("Guardian");
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        cnl.add("Gargoyle"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Rd06").revealCreatures(cnl);
        aps.getLeaf("Rd06").addCreature("Angel");
        aps.printLeaves();

        turn = 9;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Gd05").revealCreatures(cnl);
        aps.getLeaf("Gd05").addCreature("Lion");
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Centaur");
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 3);
        assertEquals(aps.getLeaf("Gd04").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Gd05").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gd06").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 0);
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Bu01").revealCreatures(cnl);
        aps.getLeaf("Bu01").addCreature("Lion");
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bu02").revealCreatures(cnl);
        aps.getLeaf("Bu02").addCreature("Guardian");
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Bu05").revealCreatures(cnl);
        aps.getLeaf("Bu05").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Bu12").revealCreatures(cnl);
        aps.getLeaf("Bu12").addCreature("Cyclops");
        aps.getLeaf("Gr01").split(2, "Gr04", turn);
        aps.getLeaf("Bu01").removeCreature("Lion");
        aps.getLeaf("Bu01").removeCreature("Centaur");
        aps.getLeaf("Bu01").removeCreature("Centaur");
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Gr03").revealCreatures(cnl);
        aps.getLeaf("Gr03").addCreature("Lion");
        cnl.clear();
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Gr04").revealCreatures(cnl);
        aps.getLeaf("Gr04").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Ogre");
        cnl.clear();
        cnl.add("Lion"); 
        aps.getLeaf("Gr12").revealCreatures(cnl);
        aps.getLeaf("Gr12").addCreature("Lion");
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").addCreature("Cyclops");
        aps.getLeaf("Bk10").split(2, "Bk11", turn);
        cnl.clear();
        cnl.add("Angel"); 
        cnl.add("Troll"); 
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Angel"); 
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Br06").revealCreatures(cnl);
        aps.getLeaf("Br06").removeCreature("Lion");
        aps.getLeaf("Br06").removeCreature("Lion");
        aps.getLeaf("Bk06").removeCreature("Angel");
        aps.getLeaf("Br06").removeCreature("Lion");
        aps.getLeaf("Bk06").removeCreature("Ogre");
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Br06").revealCreatures(cnl);
        aps.getLeaf("Br06").addCreature("Ogre");
        aps.getLeaf("Br06").removeCreature("Angel");
        aps.getLeaf("Bk06").removeCreature("Lion");
        aps.getLeaf("Br06").removeCreature("Ogre");
        aps.getLeaf("Bk06").removeCreature("Lion");
        aps.getLeaf("Br06").removeCreature("Ogre");
        aps.getLeaf("Bk06").removeCreature("Lion");
        aps.getLeaf("Br06").removeCreature("Ogre");
        aps.getLeaf("Bk06").removeCreature("Ogre");
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Angel");
        aps.getLeaf("Gd05").removeCreature("Lion");
        aps.getLeaf("Gd05").removeCreature("Centaur");
        aps.getLeaf("Gd05").removeCreature("Centaur");
        aps.getLeaf("Gd05").removeCreature("Ogre");
        aps.getLeaf("Bk11").removeCreature("Ogre");
        aps.getLeaf("Bk11").removeCreature("Ogre");
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Rd06").revealCreatures(cnl);
        aps.getLeaf("Rd06").addCreature("Warlock");
        cnl.clear();
        cnl.add("Gargoyle"); 
        aps.getLeaf("Rd02").revealCreatures(cnl);
        aps.getLeaf("Rd02").addCreature("Gargoyle");
        aps.printLeaves();

        turn = 10;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Gorgon");
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 3);
        assertEquals(aps.getLeaf("Gd04").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Gd06").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 0);
        aps.getLeaf("Bu05").split(2, "Bu10", turn);
        aps.getLeaf("Rd02").removeCreature("Gargoyle");
        aps.getLeaf("Rd02").removeCreature("Gargoyle");
        aps.getLeaf("Rd02").removeCreature("Ogre");
        aps.getLeaf("Rd02").removeCreature("Ogre");
        aps.getLeaf("Rd02").removeCreature("Ogre");
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Bu07").revealCreatures(cnl);
        aps.getLeaf("Bu07").addCreature("Lion");
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Gr01").revealCreatures(cnl);
        aps.getLeaf("Gr01").addCreature("Ogre");
        cnl.clear();
        cnl.add("Lion"); 
        aps.getLeaf("Gr03").revealCreatures(cnl);
        aps.getLeaf("Gr03").addCreature("Lion");
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Troll");
        cnl.clear();
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").addCreature("Troll");
        cnl.clear();
        cnl.add("Unicorn"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Unicorn");
        aps.getLeaf("Br09").removeCreature("Gargoyle");
        aps.getLeaf("Br09").removeCreature("Gargoyle");
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Behemoth");
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Bk12").revealCreatures(cnl);
        aps.getLeaf("Bk12").addCreature("Warbear");
        aps.getLeaf("Rd06").split(2, "Rd09", turn);
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Rd09").revealCreatures(cnl);
        aps.getLeaf("Rd09").addCreature("Centaur");
        aps.printLeaves();

        turn = 11;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd07", turn);
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd07"), turn);
        aps.getLeaf("Bu02").split(2, "Bu04", turn);
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 3);
        assertEquals(aps.getLeaf("Gd04").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Gd06").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 0);
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bu02").revealCreatures(cnl);
        aps.getLeaf("Bu02").addCreature("Ranger");
        cnl.clear();
        cnl.add("Warlock"); 
        aps.getLeaf("Bu05").revealCreatures(cnl);
        aps.getLeaf("Bu05").addCreature("Warlock");
        cnl.clear();
        cnl.add("Lion"); 
        aps.getLeaf("Bu07").revealCreatures(cnl);
        aps.getLeaf("Bu07").addCreature("Lion");
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Bu12").revealCreatures(cnl);
        aps.getLeaf("Bu12").addCreature("Guardian");
        aps.getLeaf("Gr08").split(2, "Gr02", turn);
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr02"), turn);
        cnl.clear();
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Gr01").revealCreatures(cnl);
        aps.getLeaf("Gr01").addCreature("Troll");
        aps.getLeaf("Br01").split(2, "Br03", turn);
        aps.getLeaf("Br01").merge(aps.getLeaf("Br03"), turn);
        aps.getLeaf("Br12").split(2, "Br07", turn);
        aps.getLeaf("Br12").merge(aps.getLeaf("Br07"), turn);
        aps.getLeaf("Gd04").removeCreature("Lion");
        aps.getLeaf("Gd04").removeCreature("Lion");
        aps.getLeaf("Bu04").removeCreature("Troll");
        aps.getLeaf("Bu04").removeCreature("Ogre");
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Gorgon");
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Rd06").revealCreatures(cnl);
        aps.getLeaf("Rd06").addCreature("Cyclops");
        aps.printLeaves();
        turn = 12;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd08", turn);
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd08"), turn);
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gd06").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 0);
        cnl.clear();
        cnl.add("Gorgon"); 
        aps.getLeaf("Bu05").revealCreatures(cnl);
        aps.getLeaf("Bu05").addCreature("Gorgon");
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Bu07").revealCreatures(cnl);
        aps.getLeaf("Bu07").addCreature("Ogre");
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Bu12").revealCreatures(cnl);
        aps.getLeaf("Bu12").addCreature("Gorgon");
        aps.getLeaf("Gr08").split(2, "Gr10", turn);
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr10"), turn);
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Gr01").revealCreatures(cnl);
        aps.getLeaf("Gr01").addCreature("Cyclops");
        aps.getLeaf("Br01").split(2, "Br02", turn);
        aps.getLeaf("Br01").merge(aps.getLeaf("Br02"), turn);
        aps.getLeaf("Br12").split(2, "Br06", turn);
        aps.getLeaf("Br12").merge(aps.getLeaf("Br06"), turn);
        aps.getLeaf("Gd12").removeCreature("Cyclops");
        aps.getLeaf("Gd12").removeCreature("Cyclops");
        aps.getLeaf("Gd12").removeCreature("Cyclops");
        aps.getLeaf("Gd12").removeCreature("Gargoyle");
        aps.getLeaf("Gd12").removeCreature("Gargoyle");
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Behemoth"); 
        cnl.add("Warlock"); 
        cnl.add("Gorgon"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Angel"); 
        cnl.add("Guardian"); 
        cnl.add("Ranger"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bu02").revealCreatures(cnl);
        aps.getLeaf("Bk10").removeCreature("Warlock");
        aps.getLeaf("Bu02").removeCreature("Angel");
        aps.getLeaf("Bk10").removeCreature("Behemoth");
        aps.getLeaf("Bu02").removeCreature("Ranger");
        aps.getLeaf("Bk10").removeCreature("Cyclops");
        aps.getLeaf("Bk06").removeCreature("Angel");
        aps.getLeaf("Bk10").addCreature("Angel");
        aps.getLeaf("Bu02").removeCreature("Troll");
        aps.getLeaf("Bu02").removeCreature("Troll");
        aps.getLeaf("Bk10").removeCreature("Angel");
        aps.getLeaf("Bu02").removeCreature("Guardian");
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Gorgon"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Angel");
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Troll");
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Rd06").revealCreatures(cnl);
        aps.getLeaf("Rd06").addCreature("Behemoth");
        aps.printLeaves();

        turn = 13;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd09", turn);
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd09"), turn);
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gd06").numUncertainCreatures(), 0);
        aps.getLeaf("Bu05").split(2, "Bu02", turn);
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Bu02").revealCreatures(cnl);
        aps.getLeaf("Bu02").addCreature("Centaur");
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Bu12").revealCreatures(cnl);
        aps.getLeaf("Bu12").addCreature("Behemoth");
        aps.getLeaf("Gr01").split(2, "Gr07", turn);
        aps.getLeaf("Gr01").merge(aps.getLeaf("Gr07"), turn);
        aps.getLeaf("Gr08").split(2, "Gr05", turn);
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr05"), turn);
        aps.getLeaf("Rd09").removeCreature("Gargoyle");
        aps.getLeaf("Rd09").removeCreature("Centaur");
        aps.getLeaf("Rd09").removeCreature("Centaur");
        aps.getLeaf("Br01").split(2, "Br07", turn);
        aps.getLeaf("Br01").merge(aps.getLeaf("Br07"), turn);
        aps.getLeaf("Br12").split(2, "Br04", turn);
        aps.getLeaf("Br12").merge(aps.getLeaf("Br04"), turn);
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Bk12").revealCreatures(cnl);
        aps.getLeaf("Bk12").addCreature("Lion");
        aps.printLeaves();

        turn = 14;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd04", turn);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Warlock");
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 3);
        assertEquals(aps.getLeaf("Gd04").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Gd06").numUncertainCreatures(), 0);
        cnl.clear();
        cnl.add("Warlock"); 
        aps.getLeaf("Bu05").revealCreatures(cnl);
        aps.getLeaf("Bu05").addCreature("Warlock");
        aps.getLeaf("Bu07").addCreature("Ogre");
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Bu10").revealCreatures(cnl);
        aps.getLeaf("Bu10").addCreature("Gorgon");
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Bu12").revealCreatures(cnl);
        aps.getLeaf("Bu12").addCreature("Gorgon");
        aps.getLeaf("Gr01").split(2, "Gr05", turn);
        aps.getLeaf("Gr08").split(2, "Gr06", turn);
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr06"), turn);
        aps.getLeaf("Br01").split(2, "Br05", turn);
        aps.getLeaf("Br12").split(2, "Br04", turn);
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").addCreature("Behemoth");
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Ranger");
        aps.printLeaves();

        turn = 15;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Gorgon"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Gorgon");
        cnl.clear();
        cnl.add("Lion"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Lion");
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Gd04").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Gd06").numUncertainCreatures(), 0);
        aps.getLeaf("Bu07").split(2, "Bu09", turn);
        aps.getLeaf("Bu12").split(2, "Bu06", turn);
        aps.getLeaf("Bu12").merge(aps.getLeaf("Bu06"), turn);
        aps.getLeaf("Bu02").addCreature("Gargoyle");
        cnl.clear();
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Bu07").revealCreatures(cnl);
        aps.getLeaf("Bu07").addCreature("Troll");
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Bu09").revealCreatures(cnl);
        aps.getLeaf("Bu09").addCreature("Lion");
        aps.getLeaf("Bu10").addCreature("Gargoyle");
        aps.getLeaf("Gr08").split(2, "Gr06", turn);
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr06"), turn);
        cnl.clear();
        cnl.add("Lion"); 
        aps.getLeaf("Gr03").revealCreatures(cnl);
        aps.getLeaf("Gr03").addCreature("Lion");
        aps.getLeaf("Bk12").removeCreature("Warbear");
        aps.getLeaf("Bk12").removeCreature("Lion");
        aps.getLeaf("Bk12").removeCreature("Centaur");
        aps.getLeaf("Bk12").removeCreature("Centaur");
        aps.getLeaf("Bk12").removeCreature("Centaur");
        aps.getLeaf("Br01").addCreature("Angel");
        cnl.clear();
        cnl.add("Unicorn"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Unicorn");
        cnl.clear();
        cnl.add("Lion"); 
        aps.getLeaf("Bk04").revealCreatures(cnl);
        aps.getLeaf("Bk04").addCreature("Lion");
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Troll");
        aps.getLeaf("Br05").removeCreature("Ogre");
        aps.getLeaf("Br05").removeCreature("Ogre");
        aps.printLeaves();

        turn = 16;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd12", turn);
        cnl.clear();
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Minotaur");
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 5);
        assertEquals(aps.getLeaf("Gd04").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Gd06").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 2);
        aps.getLeaf("Bu12").split(2, "Bu01", turn);
        aps.getLeaf("Bu12").merge(aps.getLeaf("Bu01"), turn);
        cnl.clear();
        cnl.add("Gorgon"); 
        aps.getLeaf("Bu05").revealCreatures(cnl);
        aps.getLeaf("Bu05").addCreature("Gorgon");
        aps.getLeaf("Gr08").split(2, "Gr11", turn);
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr11"), turn);
        cnl.clear();
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Gr05").revealCreatures(cnl);
        aps.getLeaf("Gr05").addCreature("Troll");
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Gr09").revealCreatures(cnl);
        aps.getLeaf("Gr09").addCreature("Gorgon");
        aps.getLeaf("Br01").split(2, "Br03", turn);
        aps.getLeaf("Br01").merge(aps.getLeaf("Br03"), turn);
        cnl.clear();
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        aps.getLeaf("Bk04").revealCreatures(cnl);
        aps.getLeaf("Bk04").addCreature("Ranger");
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Ranger");
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Gorgon");
        aps.getLeaf("Rd06").split(2, "Rd11", turn);
        aps.printLeaves();

        turn = 17;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Behemoth"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Behemoth");
        cnl.clear();
        cnl.add("Gorgon"); 
        aps.getLeaf("Gd12").revealCreatures(cnl);
        aps.getLeaf("Gd12").addCreature("Gorgon");
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 4);
        assertEquals(aps.getLeaf("Gd04").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gd06").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 1);
        aps.getLeaf("Bu05").split(2, "Bu08", turn);
        aps.getLeaf("Bu12").split(2, "Bu01", turn);
        aps.getLeaf("Bu12").merge(aps.getLeaf("Bu01"), turn);
        cnl.clear();
        cnl.add("Lion"); 
        aps.getLeaf("Bu09").revealCreatures(cnl);
        aps.getLeaf("Bu09").addCreature("Lion");
        aps.getLeaf("Gr08").split(2, "Gr06", turn);
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr06"), turn);
        cnl.clear();
        cnl.add("Gorgon"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Gr09").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Bu07").revealCreatures(cnl);
        aps.getLeaf("Bu07").removeCreature("Troll");
        aps.getLeaf("Gr09").removeCreature("Gorgon");
        aps.getLeaf("Gr09").removeCreature("Gargoyle");
        aps.getLeaf("Bu07").removeCreature("Ogre");
        aps.getLeaf("Gr12").removeCreature("Angel");
        aps.getLeaf("Gr09").addCreature("Angel");
        aps.getLeaf("Bu07").removeCreature("Lion");
        cnl.clear();
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Bu07").revealCreatures(cnl);
        aps.getLeaf("Bu07").addCreature("Troll");
        aps.getLeaf("Bu07").removeCreature("Lion");
        aps.getLeaf("Gr09").removeCreature("Cyclops");
        aps.getLeaf("Gr09").removeCreature("Gargoyle");
        aps.getLeaf("Bu07").removeCreature("Ogre");
        aps.getLeaf("Bu07").removeCreature("Ogre");
        aps.getLeaf("Gr09").removeCreature("Cyclops");
        aps.getLeaf("Bu07").removeCreature("Troll");
        cnl.clear();
        cnl.add("Angel"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Gr09").revealCreatures(cnl);
        aps.getLeaf("Gr09").addCreature("Angel");
        aps.getLeaf("Br01").split(2, "Br05", turn);
        aps.getLeaf("Br01").merge(aps.getLeaf("Br05"), turn);
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Br04").revealCreatures(cnl);
        aps.getLeaf("Br04").addCreature("Lion");
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Angel"); 
        cnl.add("Behemoth"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Rd06").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Gr03").revealCreatures(cnl);
        aps.getLeaf("Gr03").removeCreature("Centaur");
        aps.getLeaf("Gr03").removeCreature("Centaur");
        aps.getLeaf("Gr03").removeCreature("Lion");
        aps.getLeaf("Gr03").removeCreature("Lion");
        aps.getLeaf("Gr03").removeCreature("Lion");
        aps.getLeaf("Gr03").removeCreature("Centaur");
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Angel"); 
        cnl.add("Behemoth"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Rd06").revealCreatures(cnl);
        aps.getLeaf("Rd06").addCreature("Angel");
        cnl.clear();
        cnl.add("Warlock"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Rd11").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Bu09").revealCreatures(cnl);
        aps.getLeaf("Bu09").removeCreature("Lion");
        aps.getLeaf("Bu09").removeCreature("Centaur");
        aps.getLeaf("Rd11").removeCreature("Cyclops");
        cnl.clear();
        cnl.add("Lion"); 
        aps.getLeaf("Bu09").revealCreatures(cnl);
        aps.getLeaf("Bu09").addCreature("Lion");
        aps.getLeaf("Rd11").removeCreature("Warlock");
        cnl.clear();
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Bu09").revealCreatures(cnl);
        aps.printLeaves();

        turn = 18;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd06").split(2, "Gd10", turn);
        aps.getLeaf("Gd06").merge(aps.getLeaf("Gd10"), turn);
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Gd04").revealCreatures(cnl);
        aps.getLeaf("Gd04").addCreature("Gorgon");
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 3);
        assertEquals(aps.getLeaf("Gd04").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gd06").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 1);
        aps.getLeaf("Bu12").split(2, "Bu04", turn);
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Bu04").revealCreatures(cnl);
        aps.getLeaf("Bu04").addCreature("Gorgon");
        aps.getLeaf("Gr08").split(2, "Gr06", turn);
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr06"), turn);
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Gr01").revealCreatures(cnl);
        aps.getLeaf("Gr01").addCreature("Troll");
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Gr04").revealCreatures(cnl);
        aps.getLeaf("Gr04").addCreature("Gargoyle");
        aps.getLeaf("Gr05").addCreature("Gargoyle");
        aps.getLeaf("Gr09").addCreature("Gargoyle");
        aps.getLeaf("Br01").split(2, "Br06", turn);
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").addCreature("Gorgon");
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Angel"); 
        cnl.add("Gorgon"); 
        cnl.add("Gorgon"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Gargoyle"); 
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Gr05").revealCreatures(cnl);
        aps.getLeaf("Gr05").removeCreature("Gargoyle");
        aps.getLeaf("Gr05").removeCreature("Ogre");
        aps.getLeaf("Bk10").removeCreature("Angel");
        aps.getLeaf("Gr05").removeCreature("Troll");
        aps.getLeaf("Bk10").removeCreature("Gorgon");
        aps.getLeaf("Gr05").removeCreature("Ogre");
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Gorgon"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Angel");
        cnl.clear();
        cnl.add("Ranger"); 
        cnl.add("Ranger"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        aps.getLeaf("Gr12").revealCreatures(cnl);
        aps.getLeaf("Gr12").removeCreature("Cyclops");
        aps.getLeaf("Gr12").removeCreature("Lion");
        aps.getLeaf("Bk06").removeCreature("Ranger");
        aps.getLeaf("Bk10").removeCreature("Angel");
        aps.getLeaf("Bk06").addCreature("Angel");
        aps.getLeaf("Gr12").removeCreature("Lion");
        aps.getLeaf("Bk06").removeCreature("Ranger");
        cnl.clear();
        cnl.add("Angel"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        aps.getLeaf("Bk04").revealCreatures(cnl);
        aps.getLeaf("Bk04").addCreature("Ranger");
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Warlock");
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Angel"); 
        cnl.add("Angel"); 
        cnl.add("Behemoth"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Rd06").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Gr04").revealCreatures(cnl);
        aps.getLeaf("Gr04").removeCreature("Gargoyle");
        aps.getLeaf("Gr04").removeCreature("Gargoyle");
        aps.getLeaf("Gr04").removeCreature("Cyclops");
        aps.getLeaf("Gr04").removeCreature("Gargoyle");
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Angel"); 
        cnl.add("Angel"); 
        cnl.add("Behemoth"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Rd06").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Rd06").revealCreatures(cnl);
        aps.getLeaf("Rd06").addCreature("Gorgon");
        aps.printLeaves();

        turn = 19;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd06").split(2, "Gd10", turn);
        aps.getLeaf("Gd06").merge(aps.getLeaf("Gd10"), turn);
        cnl.clear();
        cnl.add("Lion"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Lion");
        assertEquals(aps.getLeaf("Gd03").numUncertainCreatures(), 3);
        assertEquals(aps.getLeaf("Gd04").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gd06").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 1);
        cnl.clear();
        cnl.add("Gorgon"); 
        aps.getLeaf("Bu02").revealCreatures(cnl);
        aps.getLeaf("Bu02").addCreature("Gorgon");
        cnl.clear();
        cnl.add("Guardian"); 
        aps.getLeaf("Bu12").revealCreatures(cnl);
        aps.getLeaf("Bu12").addCreature("Guardian");
        aps.getLeaf("Gr08").split(2, "Gr07", turn);
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr07"), turn);
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Gr01").revealCreatures(cnl);
        aps.getLeaf("Gr01").addCreature("Gorgon");
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Wyvern");
        aps.printLeaves();
        turn = 20;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd06").split(2, "Gd08", turn);
        cnl.clear();
        cnl.add("Behemoth"); 
        cnl.add("Behemoth"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Serpent");
        cnl.clear();
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Guardian");
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Bu02").revealCreatures(cnl);
        aps.getLeaf("Bu02").addCreature("Lion");
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Bu10").revealCreatures(cnl);
        aps.getLeaf("Bu10").addCreature("Gorgon");
        aps.getLeaf("Gr01").split(2, "Gr03", turn);
        aps.getLeaf("Gr01").merge(aps.getLeaf("Gr03"), turn);
        aps.getLeaf("Gr08").split(2, "Gr02", turn);
        aps.getLeaf("Bu08").removeCreature("Gorgon");
        aps.getLeaf("Bu08").removeCreature("Gorgon");
        cnl.clear();
        cnl.add("Behemoth"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").addCreature("Behemoth");
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Br06").revealCreatures(cnl);
        aps.getLeaf("Br06").addCreature("Troll");
        cnl.clear();
        cnl.add("Angel"); 
        cnl.add("Wyvern"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Gorgon"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Gd04").revealCreatures(cnl);
        aps.getLeaf("Gd04").removeCreature("Gorgon");
        aps.getLeaf("Bk06").removeCreature("Angel");
        aps.getLeaf("Gd04").removeCreature("Cyclops");
        aps.getLeaf("Bk06").removeCreature("Wyvern");
        aps.getLeaf("Gd04").removeCreature("Cyclops");
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Angel");
        aps.getLeaf("Br04").removeCreature("Lion");
        aps.getLeaf("Br04").removeCreature("Centaur");
        aps.getLeaf("Br04").removeCreature("Centaur");
        aps.printLeaves();
        turn = 21;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd07", turn);
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd07"), turn);
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Bu04").revealCreatures(cnl);
        aps.getLeaf("Bu04").addCreature("Gorgon");
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Bu10").revealCreatures(cnl);
        aps.getLeaf("Bu10").addCreature("Gorgon");
        aps.getLeaf("Gr01").split(2, "Gr05", turn);
        cnl.clear();
        cnl.add("Gorgon"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        cnl.add("Troll"); 
        aps.getLeaf("Gr01").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Warlock"); 
        cnl.add("Warlock"); 
        cnl.add("Warlock"); 
        cnl.add("Warlock"); 
        aps.getLeaf("Bu05").revealCreatures(cnl);
        aps.getLeaf("Gr01").removeCreature("Gorgon");
        aps.getLeaf("Bu05").removeCreature("Warlock");
        aps.getLeaf("Gr01").removeCreature("Cyclops");
        aps.getLeaf("Gr09").removeCreature("Angel");
        aps.getLeaf("Gr01").addCreature("Angel");
        aps.getLeaf("Bu05").removeCreature("Warlock");
        aps.getLeaf("Gr01").removeCreature("Angel");
        aps.getLeaf("Gr01").removeCreature("Troll");
        aps.getLeaf("Bu05").removeCreature("Warlock");
        aps.getLeaf("Gr01").removeCreature("Cyclops");
        aps.getLeaf("Gr01").removeCreature("Cyclops");
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Warlock"); 
        aps.getLeaf("Bu05").revealCreatures(cnl);
        aps.getLeaf("Bu05").addCreature("Angel");
        aps.getLeaf("Br01").split(2, "Br10", turn);
        aps.getLeaf("Br01").merge(aps.getLeaf("Br10"), turn);
        aps.printLeaves();
        turn = 22;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd09", turn);
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd09"), turn);
        cnl.clear();
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Griffon");
        cnl.clear();
        cnl.add("Gorgon"); 
        aps.getLeaf("Gd12").revealCreatures(cnl);
        aps.getLeaf("Gd12").addCreature("Gorgon");
        aps.getLeaf("Bu09").removeCreature("Lion");
        aps.getLeaf("Bu09").removeCreature("Lion");
        aps.getLeaf("Bu09").removeCreature("Centaur");
        aps.getLeaf("Br01").split(2, "Br07", turn);
        aps.getLeaf("Br01").merge(aps.getLeaf("Br07"), turn);
        cnl.clear();
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        aps.getLeaf("Bk04").revealCreatures(cnl);
        aps.getLeaf("Bk04").addCreature("Ranger");
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Warbear");
        aps.getLeaf("Rd06").split(2, "Rd07", turn);
        cnl.clear();
        cnl.add("Gorgon"); 
        aps.getLeaf("Rd06").revealCreatures(cnl);
        aps.getLeaf("Rd06").addCreature("Gorgon");
        aps.printLeaves();
        turn = 23;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd05", turn);
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd05"), turn);
        aps.getLeaf("Gd06").split(2, "Gd04", turn);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Serpent"); 
        cnl.add("Behemoth"); 
        cnl.add("Behemoth"); 
        cnl.add("Warlock"); 
        cnl.add("Gorgon"); 
        cnl.add("Gorgon"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Angel"); 
        cnl.add("Behemoth"); 
        cnl.add("Gorgon"); 
        cnl.add("Gorgon"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Rd06").revealCreatures(cnl);
        aps.getLeaf("Rd06").removeCreature("Angel");
        aps.getLeaf("Rd06").removeCreature("Behemoth");
        aps.getLeaf("Gd03").removeCreature("Gorgon");
        aps.getLeaf("Rd06").removeCreature("Gorgon");
        aps.getLeaf("Rd06").removeCreature("Gorgon");
        aps.getLeaf("Rd06").removeCreature("Cyclops");
        aps.getLeaf("Gd03").removeCreature("Gorgon");
        aps.getLeaf("Gd03").removeCreature("Serpent");
        aps.getLeaf("Rd06").removeCreature("Titan");
        aps.getLeaf("Gd03").removeCreature("Warlock");
        aps.getLeaf("Rd07").removeCreature("Angel");
        aps.getLeaf("Rd07").removeCreature("Cyclops");
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Behemoth"); 
        cnl.add("Behemoth"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Angel");
        cnl.clear();
        cnl.add("Griffon"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Griffon");
        cnl.clear();
        cnl.add("Gorgon"); 
        aps.getLeaf("Gd12").revealCreatures(cnl);
        aps.getLeaf("Gd12").addCreature("Gorgon");
        aps.getLeaf("Br01").split(2, "Br09", turn);
        aps.getLeaf("Br01").merge(aps.getLeaf("Br09"), turn);
        aps.getLeaf("Bk04").split(2, "Bk01", turn);
        cnl.clear();
        cnl.add("Angel"); 
        cnl.add("Warbear"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Angel"); 
        cnl.add("Cyclops"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Gr09").revealCreatures(cnl);
        aps.getLeaf("Gr09").removeCreature("Gargoyle");
        aps.getLeaf("Bk06").removeCreature("Troll");
        aps.getLeaf("Gr09").removeCreature("Angel");
        aps.getLeaf("Gr09").removeCreature("Cyclops");
        aps.getLeaf("Bk06").removeCreature("Angel");
        cnl.clear();
        cnl.add("Warbear"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        aps.getLeaf("Bk04").revealCreatures(cnl);
        aps.getLeaf("Bk04").addCreature("Minotaur");
        cnl.clear();
        cnl.add("Behemoth"); 
        aps.getLeaf("Bu12").revealCreatures(cnl);
        aps.getLeaf("Bu12").addCreature("Behemoth");
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Gr05").revealCreatures(cnl);
        aps.getLeaf("Gr05").addCreature("Troll");
        aps.printLeaves();
        turn = 24;
        Log.debug("Turn " + turn);
        aps.getLeaf("Br01").split(2, "Br07", turn);
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Troll");
        cnl.clear();
        cnl.add("Behemoth"); 
        cnl.add("Behemoth"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Serpent");
        cnl.clear();
        cnl.add("Guardian"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Guardian");
        cnl.clear();
        cnl.add("Gorgon"); 
        cnl.add("Gorgon"); 
        cnl.add("Gorgon"); 
        aps.getLeaf("Gd12").revealCreatures(cnl);
        aps.getLeaf("Gd12").addCreature("Guardian");
        aps.printLeaves();
        turn = 25;
        Log.debug("Turn " + turn);
        aps.getLeaf("Bu12").split(2, "Bu07", turn);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Gr08").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Cyclops"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Br06").revealCreatures(cnl);
        aps.getLeaf("Gr08").removeCreature("Ogre");
        aps.getLeaf("Br06").removeCreature("Cyclops");
        aps.getLeaf("Gr08").removeCreature("Troll");
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Br06").revealCreatures(cnl);
        aps.getLeaf("Br06").addCreature("Ranger");
        aps.getLeaf("Br06").removeCreature("Troll");
        aps.getLeaf("Gr08").removeCreature("Troll");
        aps.getLeaf("Br06").removeCreature("Ranger");
        aps.getLeaf("Br06").removeCreature("Troll");
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Troll"); 
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Angel");
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Gr08").addCreature("Troll");
        cnl.clear();
        cnl.add("Ranger"); 
        cnl.add("Ranger"); 
        cnl.add("Ranger"); 
        cnl.add("Minotaur"); 
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        aps.getLeaf("Bk04").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Angel"); 
        cnl.add("Warlock"); 
        aps.getLeaf("Bu05").revealCreatures(cnl);
        aps.getLeaf("Bk04").removeCreature("Ranger");
        aps.getLeaf("Bu05").removeCreature("Angel");
        aps.getLeaf("Bu05").removeCreature("Warlock");
        aps.getLeaf("Bk04").removeCreature("Minotaur");
        aps.getLeaf("Bk04").removeCreature("Lion");
        aps.getLeaf("Bk04").removeCreature("Ranger");
        aps.getLeaf("Bk04").removeCreature("Ranger");
        aps.getLeaf("Bu05").removeCreature("Titan");
        aps.getLeaf("Bk04").removeCreature("Lion");
        aps.getLeaf("Bu12").removeCreature("Guardian");
        aps.getLeaf("Bu12").removeCreature("Guardian");
        aps.getLeaf("Bu12").removeCreature("Behemoth");
        aps.getLeaf("Bu12").removeCreature("Behemoth");
        aps.getLeaf("Bu12").removeCreature("Gorgon");
        aps.getLeaf("Bu10").removeCreature("Gorgon");
        aps.getLeaf("Bu10").removeCreature("Gorgon");
        aps.getLeaf("Bu10").removeCreature("Cyclops");
        aps.getLeaf("Bu10").removeCreature("Cyclops");
        aps.getLeaf("Bu10").removeCreature("Gargoyle");
        aps.getLeaf("Bu10").removeCreature("Gorgon");
        aps.getLeaf("Bu02").removeCreature("Gorgon");
        aps.getLeaf("Bu02").removeCreature("Gorgon");
        aps.getLeaf("Bu02").removeCreature("Gargoyle");
        aps.getLeaf("Bu02").removeCreature("Centaur");
        aps.getLeaf("Bu02").removeCreature("Centaur");
        aps.getLeaf("Bu02").removeCreature("Lion");
        aps.getLeaf("Bu04").removeCreature("Gorgon");
        aps.getLeaf("Bu04").removeCreature("Cyclops");
        aps.getLeaf("Bu04").removeCreature("Cyclops");
        aps.getLeaf("Bu04").removeCreature("Gorgon");
        aps.getLeaf("Bu07").removeCreature("Gorgon");
        aps.getLeaf("Bu07").removeCreature("Cyclops");
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Wyvern");
        aps.printLeaves();
        turn = 26;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd06").split(2, "Gd11", turn);
        cnl.clear();
        cnl.add("Minotaur"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Minotaur");
        cnl.clear();
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        aps.getLeaf("Gd11").revealCreatures(cnl);
        aps.getLeaf("Gd11").addCreature("Ranger");
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Warlock"); 
        cnl.add("Gorgon"); 
        cnl.add("Cyclops"); 
        cnl.add("Cyclops"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Angel"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Gr08").revealCreatures(cnl);
        aps.getLeaf("Bk10").removeCreature("Gorgon");
        aps.getLeaf("Gr08").removeCreature("Troll");
        aps.getLeaf("Gr08").removeCreature("Troll");
        aps.getLeaf("Bk10").removeCreature("Warlock");
        aps.getLeaf("Bk10").removeCreature("Cyclops");
        aps.getLeaf("Bk10").removeCreature("Cyclops");
        aps.getLeaf("Gr08").removeCreature("Titan");
        aps.getLeaf("Gr08").removeCreature("Angel");
        aps.getLeaf("Gr02").removeCreature("Ogre");
        aps.getLeaf("Gr02").removeCreature("Ogre");
        aps.getLeaf("Gr05").removeCreature("Troll");
        aps.getLeaf("Gr05").removeCreature("Ogre");
        aps.getLeaf("Gr05").removeCreature("Troll");
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Angel");
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Gd11").revealCreatures(cnl);
        aps.getLeaf("Gd11").addCreature("Ranger");
        cnl.clear();
        cnl.add("Behemoth"); 
        cnl.add("Behemoth"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").addCreature("Serpent");
        cnl.clear();
        cnl.add("Warbear"); 
        cnl.add("Warbear"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Unicorn");
        cnl.clear();
        cnl.add("Serpent"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Serpent");
        cnl.clear();
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        aps.getLeaf("Gd11").revealCreatures(cnl);
        aps.getLeaf("Gd11").addCreature("Ranger");
        aps.printLeaves();
        turn = 28;
        Log.debug("Turn " + turn);
        aps.getLeaf("Br12").split(2, "Br04", turn);
        cnl.clear();
        cnl.add("Warbear"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Warbear");
        cnl.clear();
        cnl.add("Griffon"); 
        cnl.add("Griffon"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Hydra");
        aps.printLeaves();
        turn = 30;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd06").split(2, "Gd10", turn);
        cnl.clear();
        cnl.add("Ranger"); 
        cnl.add("Ranger"); 
        cnl.add("Ranger"); 
        aps.getLeaf("Gd11").revealCreatures(cnl);
        aps.getLeaf("Gd11").addCreature("Guardian");
        cnl.clear();
        cnl.add("Unicorn"); 
        cnl.add("Unicorn"); 
        cnl.add("Unicorn"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Guardian");
        aps.getLeaf("Br07").removeCreature("Cyclops");
        aps.getLeaf("Br07").removeCreature("Cyclops");
        aps.getLeaf("Bk10").addCreature("Angel");
        aps.getLeaf("Gd08").removeCreature("Centaur");
        aps.getLeaf("Gd08").removeCreature("Centaur");
        cnl.clear();
        cnl.add("Wyvern"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Wyvern");
        cnl.clear();
        cnl.add("Minotaur"); 
        cnl.add("Minotaur"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Unicorn");
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Gd11").revealCreatures(cnl);
        aps.getLeaf("Gd11").addCreature("Ranger");
        aps.printLeaves();
        turn = 31;
        Log.debug("Turn " + turn);
        aps.getLeaf("Bk06").split(2, "Bk02", turn);
        aps.getLeaf("Gd04").removeCreature("Lion");
        aps.getLeaf("Gd04").removeCreature("Centaur");
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Troll");
        aps.printLeaves();
        turn = 32;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd06").split(2, "Gd01", turn);
        aps.getLeaf("Gd11").split(2, "Gd05", turn);
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Gd11").revealCreatures(cnl);
        aps.getLeaf("Gd11").addCreature("Ranger");
        cnl.clear();
        cnl.add("Warbear"); 
        cnl.add("Warbear"); 
        aps.getLeaf("Br04").revealCreatures(cnl);
        aps.getLeaf("Br04").addCreature("Unicorn");
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk02").revealCreatures(cnl);
        aps.getLeaf("Bk02").addCreature("Ranger");
        cnl.clear();
        cnl.add("Serpent"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Serpent");
        cnl.clear();
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        aps.getLeaf("Gd05").revealCreatures(cnl);
        aps.getLeaf("Gd05").addCreature("Ranger");
        cnl.clear();
        cnl.add("Hydra"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Hydra");
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Gd11").revealCreatures(cnl);
        aps.getLeaf("Gd11").addCreature("Ranger");
        cnl.clear();
        cnl.add("Unicorn"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Unicorn");
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Br04").removeCreature("Unicorn");
        aps.getLeaf("Br04").removeCreature("Warbear");
        aps.getLeaf("Br04").removeCreature("Warbear");
        cnl.clear();
        cnl.add("Wyvern"); 
        cnl.add("Wyvern"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Hydra");
        aps.printLeaves();
        turn = 34;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd07", turn);
        aps.getLeaf("Gd11").split(2, "Gd02", turn);
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Gd02").revealCreatures(cnl);
        aps.getLeaf("Gd02").addCreature("Ranger");
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Gd05").revealCreatures(cnl);
        aps.getLeaf("Gd05").addCreature("Ranger");
        cnl.clear();
        cnl.add("Griffon"); 
        cnl.add("Griffon"); 
        aps.getLeaf("Gd10").revealCreatures(cnl);
        aps.getLeaf("Gd10").addCreature("Hydra");
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Gd11").revealCreatures(cnl);
        aps.getLeaf("Gd11").addCreature("Ranger");
        aps.getLeaf("Br12").split(2, "Br04", turn);
        cnl.clear();
        cnl.add("Serpent"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").addCreature("Serpent");
        aps.getLeaf("Bk06").split(2, "Bk05", turn);
        aps.getLeaf("Gd02").removeCreature("Ranger");
        aps.getLeaf("Gd02").removeCreature("Ranger");
        aps.getLeaf("Gd02").removeCreature("Ranger");
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Bk02").revealCreatures(cnl);
        aps.getLeaf("Bk02").addCreature("Troll");
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk05").revealCreatures(cnl);
        aps.getLeaf("Bk05").addCreature("Ranger");
        cnl.clear();
        cnl.add("Guardian"); 
        aps.getLeaf("Gd11").revealCreatures(cnl);
        aps.getLeaf("Gd11").addCreature("Guardian");
        aps.printLeaves();
        turn = 35;
        Log.debug("Turn " + turn);
        aps.getLeaf("Br01").split(2, "Br07", turn);
        aps.getLeaf("Gd10").removeCreature("Hydra");
        aps.getLeaf("Gd10").removeCreature("Griffon");
        aps.getLeaf("Gd10").removeCreature("Griffon");
        aps.getLeaf("Bk10").addCreature("Angel");
        cnl.clear();
        cnl.add("Ranger"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk02").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Behemoth"); 
        cnl.add("Behemoth"); 
        aps.getLeaf("Gd07").revealCreatures(cnl);
        aps.getLeaf("Bk02").removeCreature("Ranger");
        aps.getLeaf("Gd07").removeCreature("Behemoth");
        aps.getLeaf("Bk10").removeCreature("Angel");
        aps.getLeaf("Bk02").addCreature("Angel");
        aps.getLeaf("Gd07").removeCreature("Behemoth");
        aps.getLeaf("Bk02").removeCreature("Troll");
        cnl.clear();
        cnl.add("Angel"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk02").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Bk05").revealCreatures(cnl);
        aps.getLeaf("Bk05").addCreature("Troll");
        aps.printLeaves();
        turn = 36;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd11").split(2, "Gd08", turn);
        aps.getLeaf("Gd11").merge(aps.getLeaf("Gd08"), turn);
        cnl.clear();
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        aps.getLeaf("Gd05").revealCreatures(cnl);
        aps.getLeaf("Gd05").addCreature("Ranger");
        cnl.clear();
        cnl.add("Unicorn"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Unicorn");
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Bk05").revealCreatures(cnl);
        aps.getLeaf("Bk05").addCreature("Ranger");
        aps.printLeaves();
        turn = 37;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd11").split(2, "Gd08", turn);
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Gd05").revealCreatures(cnl);
        aps.getLeaf("Gd05").addCreature("Ranger");
        cnl.clear();
        cnl.add("Unicorn"); 
        aps.getLeaf("Br04").revealCreatures(cnl);
        aps.getLeaf("Br04").addCreature("Unicorn");
        cnl.clear();
        cnl.add("Unicorn"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Unicorn");
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Bk02").revealCreatures(cnl);
        aps.getLeaf("Bk02").addCreature("Troll");
        cnl.clear();
        cnl.add("Hydra"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Hydra");
        cnl.clear();
        cnl.add("Hydra"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Hydra");
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Gd08").revealCreatures(cnl);
        aps.getLeaf("Gd08").addCreature("Ranger");
        aps.printLeaves();
        turn = 38;
        Log.debug("Turn " + turn);
        aps.getLeaf("Br12").split(2, "Br09", turn);
        aps.getLeaf("Br12").merge(aps.getLeaf("Br09"), turn);
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Bk05").revealCreatures(cnl);
        aps.getLeaf("Bk05").addCreature("Ranger");
        aps.printLeaves();
        turn = 39;
        Log.debug("Turn " + turn);
        aps.getLeaf("Br12").split(2, "Br06", turn);
        aps.getLeaf("Br12").merge(aps.getLeaf("Br06"), turn);
        cnl.clear();
        cnl.add("Serpent"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").addCreature("Serpent");
        cnl.clear();
        cnl.add("Angel"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk02").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Behemoth"); 
        cnl.add("Behemoth"); 
        aps.getLeaf("Br07").revealCreatures(cnl);
        aps.getLeaf("Br07").removeCreature("Behemoth");
        aps.getLeaf("Bk02").removeCreature("Angel");
        aps.getLeaf("Bk10").removeCreature("Angel");
        aps.getLeaf("Bk02").addCreature("Angel");
        aps.getLeaf("Bk02").removeCreature("Troll");
        aps.getLeaf("Br07").removeCreature("Behemoth");
        cnl.clear();
        cnl.add("Angel"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk02").revealCreatures(cnl);
        aps.getLeaf("Bk02").addCreature("Archangel");
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Bk05").revealCreatures(cnl);
        aps.getLeaf("Bk05").addCreature("Ranger");
        cnl.clear();
        cnl.add("Wyvern"); 
        cnl.add("Wyvern"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Hydra");
        cnl.clear();
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        aps.getLeaf("Gd05").revealCreatures(cnl);
        aps.getLeaf("Gd05").addCreature("Ranger");
        aps.printLeaves();
        turn = 40;
        Log.debug("Turn " + turn);
        aps.getLeaf("Br12").split(2, "Br05", turn);
        aps.getLeaf("Br12").merge(aps.getLeaf("Br05"), turn);
        aps.getLeaf("Bk05").split(2, "Bk03", turn);
        aps.getLeaf("Br04").removeCreature("Guardian");
        aps.getLeaf("Br04").removeCreature("Unicorn");
        aps.getLeaf("Br04").removeCreature("Unicorn");
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Bk03").revealCreatures(cnl);
        aps.getLeaf("Bk03").addCreature("Ranger");
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Bk05").revealCreatures(cnl);
        aps.getLeaf("Bk05").addCreature("Ranger");
        aps.printLeaves();
        turn = 41;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd05").split(2, "Gd09", turn);
        cnl.clear();
        cnl.add("Serpent"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Serpent");
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Gd05").revealCreatures(cnl);
        aps.getLeaf("Gd05").addCreature("Troll");
        cnl.clear();
        cnl.add("Hydra"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Hydra");
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Gd11").revealCreatures(cnl);
        aps.getLeaf("Gd11").addCreature("Troll");
        aps.getLeaf("Br12").split(2, "Br03", turn);
        aps.getLeaf("Br12").merge(aps.getLeaf("Br03"), turn);
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk05").revealCreatures(cnl);
        aps.getLeaf("Bk05").addCreature("Warbear");
        aps.printLeaves();
        turn = 42;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd06").split(2, "Gd02", turn);
        aps.getLeaf("Gd06").merge(aps.getLeaf("Gd02"), turn);
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Gd11").revealCreatures(cnl);
        aps.getLeaf("Gd11").addCreature("Troll");
        aps.getLeaf("Br12").split(2, "Br08", turn);
        aps.getLeaf("Br12").merge(aps.getLeaf("Br08"), turn);
        aps.getLeaf("Bk05").split(2, "Bk12", turn);
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Bk02").revealCreatures(cnl);
        aps.getLeaf("Bk02").addCreature("Troll");
        cnl.clear();
        cnl.add("Ranger"); 
        cnl.add("Ranger"); 
        cnl.add("Ranger"); 
        aps.getLeaf("Bk03").revealCreatures(cnl);
        aps.getLeaf("Bk03").addCreature("Guardian");
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Warlock");
        aps.printLeaves();
        turn = 43;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd06").split(2, "Gd07", turn);
        aps.getLeaf("Gd11").split(2, "Gd10", turn);
        aps.getLeaf("Gd11").merge(aps.getLeaf("Gd10"), turn);
        aps.getLeaf("Br12").split(2, "Br07", turn);
        aps.getLeaf("Br12").merge(aps.getLeaf("Br07"), turn);
        aps.getLeaf("Bk06").split(2, "Bk08", turn);
        aps.printLeaves();
        turn = 44;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd11").split(2, "Gd04", turn);
        aps.getLeaf("Gd11").merge(aps.getLeaf("Gd04"), turn);
        aps.getLeaf("Br12").split(2, "Br11", turn);
        aps.getLeaf("Br12").merge(aps.getLeaf("Br11"), turn);
        aps.getLeaf("Bk01").removeCreature("Centaur");
        aps.getLeaf("Bk01").removeCreature("Centaur");
        aps.printLeaves();
        turn = 45;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd11").split(2, "Gd02", turn);
        aps.getLeaf("Gd11").merge(aps.getLeaf("Gd02"), turn);
        cnl.clear();
        cnl.add("Minotaur"); 
        cnl.add("Minotaur"); 
        aps.getLeaf("Gd01").revealCreatures(cnl);
        aps.getLeaf("Gd01").addCreature("Unicorn");
        aps.getLeaf("Br12").split(2, "Br11", turn);
        cnl.clear();
        cnl.add("Unicorn"); 
        aps.getLeaf("Br11").revealCreatures(cnl);
        aps.getLeaf("Br11").addCreature("Minotaur");
        cnl.clear();
        cnl.add("Warbear"); 
        aps.getLeaf("Bk05").revealCreatures(cnl);
        aps.getLeaf("Bk05").addCreature("Warbear");
        cnl.clear();
        cnl.add("Hydra"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Hydra");
        aps.printLeaves();
        turn = 46;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd11").split(2, "Gd02", turn);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").addCreature("Warlock");
        cnl.clear();
        cnl.add("Unicorn"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Warbear");
        cnl.clear();
        cnl.add("Hydra"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Hydra");
        aps.printLeaves();
        turn = 47;
        Log.debug("Turn " + turn);
        aps.getLeaf("Br01").split(2, "Br06", turn);
        cnl.clear();
        cnl.add("Serpent"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").addCreature("Serpent");
        aps.getLeaf("Gd07").removeCreature("Guardian");
        aps.getLeaf("Gd07").removeCreature("Guardian");
        aps.getLeaf("Gd11").removeCreature("Guardian");
        aps.getLeaf("Gd11").removeCreature("Guardian");
        aps.getLeaf("Gd11").removeCreature("Ranger");
        aps.getLeaf("Gd11").removeCreature("Troll");
        aps.getLeaf("Gd11").removeCreature("Troll");
        aps.getLeaf("Bk06").addCreature("Angel");
        cnl.clear();
        cnl.add("Serpent"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Serpent");
        cnl.clear();
        cnl.add("Unicorn"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Warbear");
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk02").revealCreatures(cnl);
        aps.getLeaf("Bk02").addCreature("Guardian");
        aps.printLeaves();
        turn = 49;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd07", turn);
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd07"), turn);
        aps.getLeaf("Gd06").split(2, "Gd07", turn);
        aps.getLeaf("Gd06").merge(aps.getLeaf("Gd07"), turn);
        cnl.clear();
        cnl.add("Unicorn"); 
        aps.getLeaf("Gd01").revealCreatures(cnl);
        aps.getLeaf("Gd01").addCreature("Warbear");
        cnl.clear();
        cnl.add("Lion"); 
        cnl.add("Lion"); 
        aps.getLeaf("Gd09").revealCreatures(cnl);
        aps.getLeaf("Gd09").addCreature("Minotaur");
        cnl.clear();
        cnl.add("Unicorn"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Minotaur");
        cnl.clear();
        cnl.add("Warbear"); 
        cnl.add("Warbear"); 
        aps.getLeaf("Bk05").revealCreatures(cnl);
        aps.getLeaf("Bk05").addCreature("Giant");
        aps.printLeaves();
        turn = 50;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd10", turn);
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd10"), turn);
        aps.getLeaf("Gd06").split(2, "Gd11", turn);
        aps.getLeaf("Gd06").merge(aps.getLeaf("Gd11"), turn);
        cnl.clear();
        cnl.add("Minotaur"); 
        aps.getLeaf("Gd01").revealCreatures(cnl);
        aps.getLeaf("Gd01").addCreature("Minotaur");
        aps.getLeaf("Br12").split(2, "Br07", turn);
        cnl.clear();
        cnl.add("Guardian"); 
        aps.getLeaf("Bk03").revealCreatures(cnl);
        aps.getLeaf("Bk03").addCreature("Guardian");
        aps.printLeaves();
        turn = 51;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd07", turn);
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd07"), turn);
        aps.getLeaf("Gd06").split(2, "Gd11", turn);
        cnl.clear();
        cnl.add("Serpent"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").addCreature("Behemoth");
        aps.getLeaf("Bk05").split(2, "Bk07", turn);
        aps.getLeaf("Gd09").removeCreature("Minotaur");
        aps.getLeaf("Gd09").removeCreature("Lion");
        aps.getLeaf("Gd09").removeCreature("Lion");
        aps.getLeaf("Gd11").removeCreature("Unicorn");
        aps.getLeaf("Gd11").removeCreature("Warbear");
        aps.printLeaves();
        turn = 52;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd04", turn);
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd04"), turn);
        cnl.clear();
        cnl.add("Hydra"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Griffon");
        aps.getLeaf("Br01").split(2, "Br03", turn);
        cnl.clear();
        cnl.add("Unicorn"); 
        aps.getLeaf("Br11").revealCreatures(cnl);
        aps.getLeaf("Br11").addCreature("Warbear");
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Br11").removeCreature("Unicorn");
        aps.getLeaf("Br11").removeCreature("Unicorn");
        aps.getLeaf("Br11").removeCreature("Warbear");
        aps.getLeaf("Br11").removeCreature("Minotaur");
        aps.getLeaf("Bk10").addCreature("Angel");
        cnl.clear();
        cnl.add("Warbear"); 
        cnl.add("Warbear"); 
        aps.getLeaf("Bk08").revealCreatures(cnl);
        aps.getLeaf("Bk08").addCreature("Giant");
        aps.printLeaves();
        turn = 53;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd09", turn);
        cnl.clear();
        cnl.add("Ranger"); 
        cnl.add("Ranger"); 
        cnl.add("Ranger"); 
        aps.getLeaf("Gd05").revealCreatures(cnl);
        aps.getLeaf("Gd05").addCreature("Guardian");
        cnl.clear();
        cnl.add("Ranger"); 
        cnl.add("Ranger"); 
        cnl.add("Ranger"); 
        aps.getLeaf("Gd08").revealCreatures(cnl);
        aps.getLeaf("Gd08").addCreature("Guardian");
        aps.getLeaf("Gd01").removeCreature("Unicorn");
        aps.getLeaf("Gd01").removeCreature("Warbear");
        aps.getLeaf("Gd01").removeCreature("Minotaur");
        aps.getLeaf("Gd01").removeCreature("Minotaur");
        aps.getLeaf("Gd01").removeCreature("Minotaur");
        aps.getLeaf("Gd02").removeCreature("Ranger");
        aps.getLeaf("Gd02").removeCreature("Ranger");
        cnl.clear();
        cnl.add("Giant"); 
        cnl.add("Warbear"); 
        cnl.add("Warbear"); 
        cnl.add("Ranger"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk05").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Serpent"); 
        cnl.add("Angel"); 
        aps.getLeaf("Gd09").revealCreatures(cnl);
        aps.getLeaf("Gd09").removeCreature("Serpent");
        aps.getLeaf("Bk05").removeCreature("Giant");
        aps.getLeaf("Bk05").removeCreature("Warbear");
        aps.getLeaf("Bk02").removeCreature("Archangel");
        aps.getLeaf("Bk05").addCreature("Archangel");
        aps.getLeaf("Gd09").removeCreature("Angel");
        cnl.clear();
        cnl.add("Archangel"); 
        cnl.add("Warbear"); 
        cnl.add("Ranger"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk05").revealCreatures(cnl);
        aps.getLeaf("Bk05").addCreature("Angel");
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk02").revealCreatures(cnl);
        aps.getLeaf("Bk02").addCreature("Wyvern");
        aps.printLeaves();
        turn = 54;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd05").split(2, "Gd07", turn);
        cnl.clear();
        cnl.add("Behemoth"); 
        aps.getLeaf("Br03").revealCreatures(cnl);
        aps.getLeaf("Br03").addCreature("Behemoth");
        cnl.clear();
        cnl.add("Serpent"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").addCreature("Behemoth");
        cnl.clear();
        cnl.add("Griffon"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Griffon");
        cnl.clear();
        cnl.add("Warbear"); 
        aps.getLeaf("Bk08").revealCreatures(cnl);
        aps.getLeaf("Bk08").addCreature("Warbear");
        aps.printLeaves();
        turn = 58;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd06").split(2, "Gd11", turn);
        cnl.clear();
        cnl.add("Warlock"); 
        aps.getLeaf("Br06").revealCreatures(cnl);
        aps.getLeaf("Br06").addCreature("Warlock");
        cnl.clear();
        cnl.add("Unicorn"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Minotaur");
        cnl.clear();
        cnl.add("Minotaur"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Minotaur");
        cnl.clear();
        cnl.add("Warlock"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Warlock");
        cnl.clear();
        cnl.add("Hydra"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Griffon");
        aps.printLeaves();
        turn = 60;
        Log.debug("Turn " + turn);
        aps.getLeaf("Br12").split(2, "Br02", turn);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Gd12").removeCreature("Guardian");
        aps.getLeaf("Gd12").removeCreature("Gorgon");
        aps.getLeaf("Gd12").removeCreature("Gorgon");
        aps.getLeaf("Gd12").removeCreature("Gorgon");
        aps.getLeaf("Gd12").removeCreature("Gorgon");
        aps.getLeaf("Gd12").removeCreature("Cyclops");
        aps.getLeaf("Gd05").removeCreature("Guardian");
        aps.getLeaf("Gd05").removeCreature("Ranger");
        aps.getLeaf("Gd05").removeCreature("Ranger");
        aps.getLeaf("Gd05").removeCreature("Ranger");
        aps.getLeaf("Gd05").removeCreature("Troll");
        aps.getLeaf("Bk10").addCreature("Angel");
        aps.getLeaf("Gd11").removeCreature("Griffon");
        aps.getLeaf("Gd11").removeCreature("Griffon");
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk07").revealCreatures(cnl);
        aps.getLeaf("Bk07").addCreature("Warbear");
        cnl.clear();
        cnl.add("Warlock"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Warlock");
        cnl.clear();
        cnl.add("Serpent"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").addCreature("Behemoth");
        cnl.clear();
        cnl.add("Behemoth"); 
        aps.getLeaf("Br03").revealCreatures(cnl);
        aps.getLeaf("Br03").addCreature("Behemoth");
        aps.printLeaves();
        turn = 61;
        Log.debug("Turn " + turn);
        aps.getLeaf("Bk10").split(2, "Bk09", turn);
        aps.getLeaf("Gd07").removeCreature("Ranger");
        aps.getLeaf("Gd07").removeCreature("Ranger");
        cnl.clear();
        cnl.add("Warbear"); 
        aps.getLeaf("Bk07").revealCreatures(cnl);
        aps.getLeaf("Bk07").addCreature("Warbear");
        aps.printLeaves();
        turn = 62;
        Log.debug("Turn " + turn);
        aps.getLeaf("Br01").split(2, "Br05", turn);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Angel"); 
        cnl.add("Angel"); 
        cnl.add("Angel"); 
        cnl.add("Warlock"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Unicorn"); 
        cnl.add("Unicorn"); 
        cnl.add("Unicorn"); 
        cnl.add("Unicorn"); 
        cnl.add("Unicorn"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").removeCreature("Unicorn");
        aps.getLeaf("Br12").removeCreature("Unicorn");
        aps.getLeaf("Br12").removeCreature("Unicorn");
        aps.getLeaf("Bk10").removeCreature("Angel");
        aps.getLeaf("Bk10").removeCreature("Angel");
        aps.getLeaf("Bk05").removeCreature("Archangel");
        aps.getLeaf("Bk10").addCreature("Archangel");
        aps.getLeaf("Br12").removeCreature("Unicorn");
        aps.getLeaf("Br12").removeCreature("Unicorn");
        aps.getLeaf("Bk10").removeCreature("Archangel");
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Angel"); 
        cnl.add("Warlock"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Archangel");
        aps.getLeaf("Gd08").removeCreature("Guardian");
        aps.getLeaf("Gd08").removeCreature("Ranger");
        aps.getLeaf("Gd08").removeCreature("Ranger");
        aps.getLeaf("Gd08").removeCreature("Ranger");
        aps.getLeaf("Bk02").addCreature("Angel");
        cnl.clear();
        cnl.add("Guardian"); 
        cnl.add("Guardian"); 
        cnl.add("Ranger"); 
        cnl.add("Ranger"); 
        cnl.add("Ranger"); 
        aps.getLeaf("Bk03").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Warlock"); 
        cnl.add("Warlock"); 
        cnl.add("Gorgon"); 
        aps.getLeaf("Br06").revealCreatures(cnl);
        aps.getLeaf("Br06").removeCreature("Warlock");
        aps.getLeaf("Bk03").removeCreature("Ranger");
        aps.getLeaf("Bk03").removeCreature("Ranger");
        aps.getLeaf("Br06").removeCreature("Warlock");
        aps.getLeaf("Br06").removeCreature("Gorgon");
        cnl.clear();
        cnl.add("Guardian"); 
        cnl.add("Guardian"); 
        cnl.add("Ranger"); 
        aps.getLeaf("Bk03").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Warbear"); 
        cnl.add("Warbear"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk07").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Warbear"); 
        cnl.add("Minotaur"); 
        aps.getLeaf("Br07").revealCreatures(cnl);
        aps.getLeaf("Br07").removeCreature("Warbear");
        aps.getLeaf("Bk07").removeCreature("Warbear");
        aps.getLeaf("Br07").removeCreature("Minotaur");
        cnl.clear();
        cnl.add("Warbear"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk07").revealCreatures(cnl);
        aps.getLeaf("Bk07").addCreature("Angel");
        cnl.clear();
        cnl.add("Warbear"); 
        aps.getLeaf("Bk08").revealCreatures(cnl);
        aps.getLeaf("Bk08").addCreature("Warbear");
        cnl.clear();
        cnl.add("Hydra"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Wyvern");
        aps.printLeaves();
        turn = 63;
        Log.debug("Turn " + turn);
        aps.getLeaf("Bk02").split(2, "Bk11", turn);
        aps.getLeaf("Bk06").split(2, "Bk04", turn);
        cnl.clear();
        cnl.add("Wyvern"); 
        aps.getLeaf("Bk02").revealCreatures(cnl);
        aps.getLeaf("Bk02").addCreature("Wyvern");
        cnl.clear();
        cnl.add("Hydra"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Wyvern");
        cnl.clear();
        cnl.add("Warbear"); 
        aps.getLeaf("Bk07").revealCreatures(cnl);
        aps.getLeaf("Bk07").addCreature("Warbear");
        cnl.clear();
        cnl.add("Warlock"); 
        aps.getLeaf("Bk09").revealCreatures(cnl);
        aps.getLeaf("Bk09").addCreature("Warlock");
        cnl.clear();
        cnl.add("Warlock"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Warlock");
        aps.printLeaves();
        turn = 64;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd06").split(2, "Gd07", turn);
        aps.getLeaf("Gd06").merge(aps.getLeaf("Gd07"), turn);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Warlock");
        aps.getLeaf("Br02").removeCreature("Minotaur");
        aps.getLeaf("Br02").removeCreature("Minotaur");
        aps.printLeaves();
        turn = 65;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd06").split(2, "Gd08", turn);
        aps.getLeaf("Gd06").merge(aps.getLeaf("Gd08"), turn);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Archangel"); 
        cnl.add("Angel"); 
        cnl.add("Warlock"); 
        cnl.add("Warlock"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Angel"); 
        cnl.add("Behemoth"); 
        cnl.add("Behemoth"); 
        cnl.add("Behemoth"); 
        aps.getLeaf("Br03").revealCreatures(cnl);
        aps.getLeaf("Br03").removeCreature("Angel");
        aps.getLeaf("Br03").removeCreature("Behemoth");
        aps.getLeaf("Bk10").removeCreature("Angel");
        aps.getLeaf("Bk05").removeCreature("Angel");
        aps.getLeaf("Bk10").addCreature("Angel");
        aps.getLeaf("Br03").removeCreature("Behemoth");
        aps.getLeaf("Bk10").removeCreature("Warlock");
        aps.getLeaf("Bk10").removeCreature("Warlock");
        aps.getLeaf("Br03").removeCreature("Behemoth");
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Archangel"); 
        cnl.add("Angel"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Angel");
        cnl.clear();
        cnl.add("Wyvern"); 
        aps.getLeaf("Bk02").revealCreatures(cnl);
        aps.getLeaf("Bk02").addCreature("Wyvern");
        cnl.clear();
        cnl.add("Warbear"); 
        aps.getLeaf("Bk05").revealCreatures(cnl);
        aps.getLeaf("Bk05").addCreature("Warbear");
        aps.printLeaves();
        turn = 66;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd06").split(2, "Gd05", turn);
        cnl.clear();
        cnl.add("Warlock"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Warlock");
        cnl.clear();
        cnl.add("Hydra"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Griffon");
        cnl.clear();
        cnl.add("Warbear"); 
        aps.getLeaf("Bk07").revealCreatures(cnl);
        aps.getLeaf("Bk07").addCreature("Warbear");
        cnl.clear();
        cnl.add("Warbear"); 
        aps.getLeaf("Bk08").revealCreatures(cnl);
        aps.getLeaf("Bk08").addCreature("Warbear");
        aps.printLeaves();
        turn = 67;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd02", turn);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Warlock");
        aps.getLeaf("Bk02").split(2, "Bk01", turn);
        aps.getLeaf("Gd05").removeCreature("Wyvern");
        aps.getLeaf("Gd05").removeCreature("Griffon");
        aps.getLeaf("Br05").removeCreature("Behemoth");
        aps.getLeaf("Br05").removeCreature("Behemoth");
        cnl.clear();
        cnl.add("Warbear"); 
        aps.getLeaf("Bk05").revealCreatures(cnl);
        aps.getLeaf("Bk05").addCreature("Warbear");
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Serpent"); 
        cnl.add("Serpent"); 
        cnl.add("Serpent"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Guardian");
        cnl.clear();
        cnl.add("Hydra"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Wyvern");
        aps.printLeaves();
        turn = 68;
        Log.debug("Turn " + turn);
        aps.getLeaf("Bk06").split(2, "Gr01", turn);
        aps.getLeaf("Bk06").merge(aps.getLeaf("Gr01"), turn);
        aps.printLeaves();
        turn = 69;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd12", turn);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Serpent"); 
        cnl.add("Serpent"); 
        cnl.add("Serpent"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Guardian");
        cnl.clear();
        cnl.add("Wyvern"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Wyvern");
        aps.getLeaf("Bk06").split(2, "Bu09", turn);
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Bk11").revealCreatures(cnl);
        aps.getLeaf("Bk11").addCreature("Warbear");
        aps.printLeaves();
        turn = 70;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd06").split(2, "Gd01", turn);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Wyvern"); 
        cnl.add("Wyvern"); 
        aps.getLeaf("Gd01").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Archangel"); 
        cnl.add("Angel"); 
        cnl.add("Angel"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Gd01").removeCreature("Wyvern");
        aps.getLeaf("Gd01").removeCreature("Wyvern");
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Archangel"); 
        cnl.add("Angel"); 
        cnl.add("Angel"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Angel");
        cnl.clear();
        cnl.add("Serpent"); 
        cnl.add("Serpent"); 
        cnl.add("Serpent"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Guardian");
        cnl.clear();
        cnl.add("Hydra"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Wyvern");
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Gd12").removeCreature("Guardian");
        aps.getLeaf("Gd12").removeCreature("Warlock");
        cnl.clear();
        cnl.add("Wyvern"); 
        aps.getLeaf("Bk01").revealCreatures(cnl);
        aps.getLeaf("Bk01").addCreature("Wyvern");
        cnl.clear();
        cnl.add("Wyvern"); 
        aps.getLeaf("Bk04").revealCreatures(cnl);
        aps.getLeaf("Bk04").addCreature("Wyvern");
        cnl.clear();
        cnl.add("Warbear"); 
        cnl.add("Warbear"); 
        aps.getLeaf("Bk05").revealCreatures(cnl);
        aps.getLeaf("Bk05").addCreature("Giant");
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Warlock");
        aps.printLeaves();
        turn = 71;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd04", turn);
        cnl.clear();
        cnl.add("Serpent"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Behemoth");
        aps.getLeaf("Bk03").removeCreature("Guardian");
        aps.getLeaf("Bk03").removeCreature("Guardian");
        aps.getLeaf("Bk03").removeCreature("Ranger");
        cnl.clear();
        cnl.add("Hydra"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Griffon");
        cnl.clear();
        cnl.add("Wyvern"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Wyvern");
        cnl.clear();
        cnl.add("Serpent"); 
        cnl.add("Serpent"); 
        cnl.add("Serpent"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").addCreature("Guardian");
        cnl.clear();
        cnl.add("Hydra"); 
        aps.getLeaf("Bu09").revealCreatures(cnl);
        aps.getLeaf("Bu09").addCreature("Wyvern");
        aps.printLeaves();
        turn = 74;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd06").split(2, "Gd11", turn);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Serpent"); 
        cnl.add("Serpent"); 
        cnl.add("Serpent"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").addCreature("Guardian");
        cnl.clear();
        cnl.add("Wyvern"); 
        aps.getLeaf("Bk02").revealCreatures(cnl);
        aps.getLeaf("Bk02").addCreature("Wyvern");
        cnl.clear();
        cnl.add("Hydra"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Griffon");
        aps.printLeaves();
        turn = 75;
        Log.debug("Turn " + turn);
        aps.getLeaf("Br01").split(2, "Br05", turn);
        cnl.clear();
        cnl.add("Griffon"); 
        aps.getLeaf("Bu09").revealCreatures(cnl);
        aps.getLeaf("Bu09").addCreature("Griffon");
        cnl.clear();
        cnl.add("Griffon"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Griffon");
        cnl.clear();
        cnl.add("Wyvern"); 
        aps.getLeaf("Gd11").revealCreatures(cnl);
        aps.getLeaf("Gd11").addCreature("Wyvern");
        aps.getLeaf("Gd11").removeCreature("Wyvern");
        aps.getLeaf("Gd11").removeCreature("Wyvern");
        aps.getLeaf("Gd11").removeCreature("Wyvern");
        cnl.clear();
        cnl.add("Wyvern"); 
        aps.getLeaf("Bk02").revealCreatures(cnl);
        aps.getLeaf("Bk02").addCreature("Wyvern");
        cnl.clear();
        cnl.add("Griffon"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Griffon");
        aps.printLeaves();
        turn = 77;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd06").split(2, "Gd08", turn);
        cnl.clear();
        cnl.add("Serpent"); 
        cnl.add("Serpent"); 
        cnl.add("Serpent"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Guardian");
        aps.printLeaves();
        turn = 78;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd01", turn);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Archangel"); 
        cnl.add("Angel"); 
        cnl.add("Angel"); 
        cnl.add("Angel"); 
        cnl.add("Warlock"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Serpent"); 
        cnl.add("Serpent"); 
        cnl.add("Serpent"); 
        cnl.add("Serpent"); 
        aps.getLeaf("Br01").revealCreatures(cnl);
        aps.getLeaf("Br01").removeCreature("Serpent");
        aps.getLeaf("Bk07").removeCreature("Angel");
        aps.getLeaf("Bk10").addCreature("Angel");
        aps.getLeaf("Br01").removeCreature("Serpent");
        aps.getLeaf("Br01").removeCreature("Serpent");
        aps.getLeaf("Bk10").removeCreature("Angel");
        aps.getLeaf("Br01").removeCreature("Titan");
        aps.getLeaf("Bk10").removeCreature("Archangel");
        aps.getLeaf("Br01").removeCreature("Serpent");
        aps.getLeaf("Br05").removeCreature("Guardian");
        aps.getLeaf("Br05").removeCreature("Guardian");
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Angel"); 
        cnl.add("Angel"); 
        cnl.add("Angel"); 
        cnl.add("Warlock"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Archangel");
        aps.getLeaf("Bk10").addCreature("Angel");
        aps.getLeaf("Gd04").removeCreature("Guardian");
        aps.getLeaf("Gd04").removeCreature("Guardian");
        aps.printLeaves();
        turn = 79;
        Log.debug("Turn " + turn);
        aps.getLeaf("Bk10").split(2, "Bk03", turn);
        aps.getLeaf("Gd01").removeCreature("Guardian");
        aps.getLeaf("Gd01").removeCreature("Behemoth");
        cnl.clear();
        cnl.add("Serpent"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Behemoth");
        cnl.clear();
        cnl.add("Griffon"); 
        aps.getLeaf("Gd08").revealCreatures(cnl);
        aps.getLeaf("Gd08").addCreature("Griffon");
        aps.printLeaves();
        turn = 80;
        Log.debug("Turn " + turn);
        aps.getLeaf("Bk02").split(2, "Gr11", turn);
        cnl.clear();
        cnl.add("Guardian"); 
        aps.getLeaf("Bk02").revealCreatures(cnl);
        aps.getLeaf("Bk02").addCreature("Guardian");
        cnl.clear();
        cnl.add("Griffon"); 
        aps.getLeaf("Bu09").revealCreatures(cnl);
        aps.getLeaf("Bu09").addCreature("Griffon");
        cnl.clear();
        cnl.add("Giant"); 
        aps.getLeaf("Bk05").revealCreatures(cnl);
        aps.getLeaf("Bk05").addCreature("Giant");
        cnl.clear();
        cnl.add("Wyvern"); 
        cnl.add("Wyvern"); 
        cnl.add("Wyvern"); 
        aps.getLeaf("Bk04").revealCreatures(cnl);
        aps.getLeaf("Bk04").addCreature("Guardian");
        cnl.clear();
        cnl.add("Griffon"); 
        aps.getLeaf("Bu09").revealCreatures(cnl);
        aps.getLeaf("Bu09").addCreature("Griffon");
        aps.printLeaves();
        turn = 84;
        Log.debug("Turn " + turn);
        aps.getLeaf("Bk05").split(2, "Gr06", turn);
        aps.getLeaf("Gd08").removeCreature("Griffon");
        aps.getLeaf("Gd08").removeCreature("Griffon");
        aps.getLeaf("Gd08").removeCreature("Griffon");
        aps.getLeaf("Bk04").addCreature("Angel");
        cnl.clear();
        cnl.add("Griffon"); 
        aps.getLeaf("Bu09").revealCreatures(cnl);
        aps.getLeaf("Bu09").addCreature("Griffon");
        aps.printLeaves();
        turn = 87;
        Log.debug("Turn " + turn);
        aps.getLeaf("Bu09").split(2, "Br07", turn);
        cnl.clear();
        cnl.add("Guardian"); 
        aps.getLeaf("Bk04").revealCreatures(cnl);
        aps.getLeaf("Bk04").addCreature("Guardian");
        cnl.clear();
        cnl.add("Giant"); 
        cnl.add("Giant"); 
        aps.getLeaf("Bk05").revealCreatures(cnl);
        aps.getLeaf("Bk05").addCreature("Colossus");
        cnl.clear();
        cnl.add("Warbear"); 
        cnl.add("Warbear"); 
        cnl.add("Warbear"); 
        aps.getLeaf("Bk08").revealCreatures(cnl);
        aps.getLeaf("Bk08").addCreature("Guardian");
        cnl.clear();
        cnl.add("Griffon"); 
        cnl.add("Griffon"); 
        cnl.add("Griffon"); 
        aps.getLeaf("Bu09").revealCreatures(cnl);
        aps.getLeaf("Bu09").addCreature("Guardian");
        aps.printLeaves();
        turn = 89;
        Log.debug("Turn " + turn);
        aps.getLeaf("Bk08").split(2, "Gr09", turn);
        cnl.clear();
        cnl.add("Serpent"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Behemoth");
        cnl.clear();
        cnl.add("Griffon"); 
        aps.getLeaf("Br07").revealCreatures(cnl);
        aps.getLeaf("Br07").addCreature("Griffon");
        aps.printLeaves();
        turn = 91;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd07", turn);
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd07"), turn);
        aps.getLeaf("Bk07").removeCreature("Warbear");
        aps.getLeaf("Bk07").removeCreature("Warbear");
        aps.getLeaf("Bk07").removeCreature("Warbear");
        aps.getLeaf("Bk07").removeCreature("Troll");
        aps.getLeaf("Bk07").removeCreature("Troll");
        cnl.clear();
        cnl.add("Giant"); 
        aps.getLeaf("Bk08").revealCreatures(cnl);
        aps.getLeaf("Bk08").addCreature("Giant");
        aps.printLeaves();
        turn = 92;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd07", turn);
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd07"), turn);
        aps.printLeaves();
        turn = 93;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd10", turn);
        cnl.clear();
        cnl.add("Serpent"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Behemoth");
        aps.getLeaf("Gd02").removeCreature("Warlock");
        aps.getLeaf("Gd02").removeCreature("Warlock");
        cnl.clear();
        cnl.add("Hydra"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Griffon");
        aps.getLeaf("Gd10").removeCreature("Behemoth");
        aps.getLeaf("Gd10").removeCreature("Behemoth");
        cnl.clear();
        cnl.add("Hydra"); 
        cnl.add("Hydra"); 
        cnl.add("Hydra"); 
        cnl.add("Hydra"); 
        cnl.add("Hydra"); 
        cnl.add("Griffon"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Angel"); 
        cnl.add("Warlock"); 
        aps.getLeaf("Bk03").revealCreatures(cnl);
        aps.getLeaf("Bk03").removeCreature("Angel");
        aps.getLeaf("Bk03").removeCreature("Warlock");
        cnl.clear();
        cnl.add("Hydra"); 
        cnl.add("Hydra"); 
        cnl.add("Hydra"); 
        cnl.add("Hydra"); 
        cnl.add("Hydra"); 
        cnl.add("Griffon"); 
        aps.getLeaf("Gd06").revealCreatures(cnl);
        aps.getLeaf("Gd06").addCreature("Angel");
        cnl.clear();
        cnl.add("Colossus"); 
        aps.getLeaf("Bk05").revealCreatures(cnl);
        aps.getLeaf("Bk05").addCreature("Colossus");
        aps.printLeaves();
        turn = 97;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd06").split(2, "Gd09", turn);
        aps.getLeaf("Gd06").merge(aps.getLeaf("Gd09"), turn);
        aps.getLeaf("Bk01").removeCreature("Wyvern");
        aps.getLeaf("Bk01").removeCreature("Wyvern");
        aps.getLeaf("Bk01").removeCreature("Troll");
        aps.printLeaves();
        turn = 98;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd06").split(2, "Gd02", turn);
        cnl.clear();
        cnl.add("Griffon"); 
        aps.getLeaf("Gd02").revealCreatures(cnl);
        aps.getLeaf("Gd02").addCreature("Griffon");
        aps.printLeaves();
        turn = 99;
        Log.debug("Turn " + turn);
        aps.getLeaf("Bk06").split(2, "Bk07", turn);
        cnl.clear();
        cnl.add("Hydra"); 
        cnl.add("Hydra"); 
        cnl.add("Hydra"); 
        cnl.add("Angel"); 
        cnl.add("Wyvern"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Angel"); 
        cnl.add("Griffon"); 
        cnl.add("Griffon"); 
        aps.getLeaf("Gd02").revealCreatures(cnl);
        aps.getLeaf("Gd02").removeCreature("Griffon");
        aps.getLeaf("Gd02").removeCreature("Griffon");
        aps.getLeaf("Bk06").removeCreature("Angel");
        aps.getLeaf("Bk10").removeCreature("Archangel");
        aps.getLeaf("Bk06").addCreature("Archangel");
        aps.getLeaf("Gd02").removeCreature("Angel");
        cnl.clear();
        cnl.add("Archangel"); 
        cnl.add("Hydra"); 
        cnl.add("Hydra"); 
        cnl.add("Hydra"); 
        cnl.add("Wyvern"); 
        aps.getLeaf("Bk06").revealCreatures(cnl);
        aps.getLeaf("Bk06").addCreature("Angel");
        cnl.clear();
        cnl.add("Angel"); 
        aps.getLeaf("Bk02").revealCreatures(cnl);
        aps.getLeaf("Bk07").removeCreature("Griffon");
        aps.getLeaf("Bk07").removeCreature("Griffon");
        aps.getLeaf("Gd06").removeCreature("Hydra");
        aps.getLeaf("Gd06").removeCreature("Hydra");
        aps.getLeaf("Gd06").removeCreature("Hydra");
        aps.getLeaf("Gd06").removeCreature("Hydra");
        aps.getLeaf("Gd06").removeCreature("Hydra");
        aps.printLeaves();
        turn = 105;
        Log.debug("Turn " + turn);
        aps.getLeaf("Bk05").split(2, "Bk03", turn);
        cnl.clear();
        cnl.add("Colossus"); 
        aps.getLeaf("Bk05").revealCreatures(cnl);
        aps.getLeaf("Bk05").addCreature("Colossus");
        cnl.clear();
        cnl.add("Warlock"); 
        aps.getLeaf("Bk09").revealCreatures(cnl);
        aps.getLeaf("Bk09").addCreature("Warlock");
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Warlock");
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Gd03").revealCreatures(cnl);
        aps.getLeaf("Gd03").addCreature("Warlock");
        cnl.clear();
        cnl.add("Warbear"); 
        cnl.add("Warbear"); 
        aps.getLeaf("Gr09").revealCreatures(cnl);
        aps.getLeaf("Gr09").addCreature("Giant");
        aps.printLeaves();
        turn = 107;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gd03").split(2, "Gd12", turn);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Gd12").removeCreature("Behemoth");
        aps.getLeaf("Gd12").removeCreature("Warlock");
        aps.printLeaves();
    }

    public void testPredictSplits10()
    {
        Log.debug("testPredictSplits10()");
        ps = new PredictSplits("Bk", "Bk06", cnl);
        ps.printLeaves();

        turn = 1;
        Log.debug("Turn " + turn);
        ps.getLeaf("Bk06").split(4, "Bk09", turn);
        cnl.clear();
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        ps.getLeaf("Bk09").revealCreatures(cnl);
        ps.getLeaf("Bk09").addCreature("Cyclops");
        assertFalse(ps.getLeaf("Bk06").allCertain());
        assertFalse(ps.getLeaf("Bk09").allCertain());
        ps.printLeaves();

        turn = 2;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Ogre");
        ps.getLeaf("Bk09").revealCreatures(cnl);
        ps.getLeaf("Bk09").addCreature("Ogre");
        assertFalse(ps.getLeaf("Bk06").allCertain());
        assertFalse(ps.getLeaf("Bk09").allCertain());
        ps.printLeaves();

        turn = 3;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Bk06").revealCreatures(cnl);
        ps.getLeaf("Bk06").addCreature("Lion");
        cnl.clear();
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        ps.getLeaf("Bk09").revealCreatures(cnl);
        ps.getLeaf("Bk09").addCreature("Cyclops");
        assertFalse(ps.getLeaf("Bk06").allCertain());
        assertFalse(ps.getLeaf("Bk09").allCertain());
        ps.printLeaves();

        turn = 4;
        Log.debug("Turn " + turn);
        ps.getLeaf("Bk09").split(2, "Bk10", turn);
        cnl.clear();
        cnl.add("Titan");
        ps.getLeaf("Bk06").revealCreatures(cnl);
        ps.getLeaf("Bk06").addCreature("Warlock");
        ps.getLeaf("Bk09").addCreature("Ogre");
        assertTrue(ps.getLeaf("Bk06").allCertain());
        assertFalse(ps.getLeaf("Bk09").allCertain());
        assertFalse(ps.getLeaf("Bk10").allCertain());
        ps.printLeaves();

        turn = 5;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Bk06").revealCreatures(cnl);
        ps.getLeaf("Bk06").addCreature("Lion");
        cnl.clear();
        cnl.add("Cyclops");
        ps.getLeaf("Bk09").revealCreatures(cnl);
        ps.getLeaf("Bk09").addCreature("Cyclops");
        assertTrue(ps.getLeaf("Bk06").allCertain());
        assertFalse(ps.getLeaf("Bk09").allCertain());
        assertFalse(ps.getLeaf("Bk10").allCertain());
        ps.printLeaves();
        ps.getLeaf("Bk10").removeCreature("Gargoyle");
        ps.getLeaf("Bk10").removeCreature("Gargoyle");
        assertTrue(ps.getLeaf("Bk06").allCertain());
        assertTrue(ps.getLeaf("Bk09").allCertain());
        ps.printLeaves();
    }

    public void testPredictSplits11()
    {
        Log.debug("testPredictSplits11()");
        ps = new PredictSplits("Bk", "Bk06", cnl);

        turn = 1;
        Log.debug("Turn " + turn);
        ps.getLeaf("Bk06").split(4, "Bk09", turn);
        cnl.clear();
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps.getLeaf("Bk06").revealCreatures(cnl);
        ps.getLeaf("Bk06").addCreature("Troll");
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Bk09").revealCreatures(cnl);
        ps.getLeaf("Bk09").addCreature("Lion");
        assertEquals(ps.getLeaf("Bk06").numUncertainCreatures(), 1);
        assertEquals(ps.getLeaf("Bk09").numUncertainCreatures(), 1);
        ps.printLeaves();

        turn = 2;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps.getLeaf("Bk06").revealCreatures(cnl);
        ps.getLeaf("Bk06").addCreature("Troll");
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Bk09").revealCreatures(cnl);
        ps.getLeaf("Bk09").addCreature("Lion");
        assertFalse(ps.getLeaf("Bk06").allCertain());
        assertFalse(ps.getLeaf("Bk09").allCertain());
        ps.printLeaves();

        turn = 4;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Gargoyle");
        ps.getLeaf("Bk06").revealCreatures(cnl);
        ps.getLeaf("Bk06").addCreature("Gargoyle");
        ps.getLeaf("Bk09").addCreature("Centaur");
        assertFalse(ps.getLeaf("Bk06").allCertain());
        assertFalse(ps.getLeaf("Bk09").allCertain());
        ps.printLeaves();

        turn = 5;
        Log.debug("Turn " + turn);
        ps.getLeaf("Bk06").split(2, "Bk08", turn);
        ps.getLeaf("Bk09").split(2, "Bk11", turn);
        cnl.clear();
        cnl.add("Angel");
        ps.getLeaf("Bk09").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        ps.getLeaf("Bk08").revealCreatures(cnl);
        ps.getLeaf("Bk08").removeCreature("Gargoyle");
        ps.getLeaf("Bk09").removeCreature("Angel");
        ps.getLeaf("Bk08").addCreature("Angel");
        ps.getLeaf("Bk08").removeCreature("Gargoyle");
        ps.getLeaf("Bk08").removeCreature("Angel");
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Bk09").revealCreatures(cnl);
        ps.getLeaf("Bk09").addCreature("Lion");
        cnl.clear();
        cnl.add("Centaur");
        cnl.add("Centaur");
        ps.getLeaf("Bk11").revealCreatures(cnl);
        ps.getLeaf("Bk11").addCreature("Lion");
        assertTrue(ps.getLeaf("Bk06").allCertain());
        assertTrue(ps.getLeaf("Bk09").allCertain());
        assertTrue(ps.getLeaf("Bk11").allCertain());
        ps.printLeaves();

        turn = 6;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Lion");
        cnl.add("Lion");
        ps.getLeaf("Bk09").revealCreatures(cnl);
        ps.getLeaf("Bk09").addCreature("Guardian");
        cnl.clear();
        cnl.add("Lion");
        ps.getLeaf("Bk11").revealCreatures(cnl);
        ps.getLeaf("Bk11").addCreature("Lion");
        assertTrue(ps.getLeaf("Bk06").allCertain());
        assertTrue(ps.getLeaf("Bk09").allCertain());
        assertTrue(ps.getLeaf("Bk11").allCertain());
        ps.printLeaves();

        turn = 7;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Lion");
        cnl.add("Lion");
        cnl.add("Lion");
        ps.getLeaf("Bk09").revealCreatures(cnl);
        ps.getLeaf("Bk09").addCreature("Griffon");
        ps.getLeaf("Bk11").removeCreature("Lion");
        ps.getLeaf("Bk11").removeCreature("Lion");
        ps.getLeaf("Bk11").removeCreature("Centaur");
        ps.getLeaf("Bk11").removeCreature("Centaur");
        assertTrue(ps.getLeaf("Bk06").allCertain());
        assertTrue(ps.getLeaf("Bk09").allCertain());
        ps.printLeaves();

        turn = 8;
        Log.debug("Turn " + turn);
        ps.getLeaf("Bk09").split(2, "Bk12", turn);
        ps.getLeaf("Bk12").removeCreature("Gargoyle");
        ps.getLeaf("Bk12").removeCreature("Centaur");
        assertTrue(ps.getLeaf("Bk06").allCertain());
        assertTrue(ps.getLeaf("Bk09").allCertain());
        ps.printLeaves();
    }



    public void testPredictSplits12()
    {
        aps.printLeaves();

        turn = 1;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Titan");
        cnl.add("Angel");
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        cnl.add("Centaur");
        cnl.add("Centaur");
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps = new PredictSplits("Gr", "Gr07", cnl);
        aps.add(ps);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Angel"); 
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Gr07").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Titan");
        cnl.add("Angel");
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        cnl.add("Centaur");
        cnl.add("Centaur");
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps = new PredictSplits("Bu", "Bu08", cnl);
        aps.add(ps);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Angel"); 
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Bu08").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Titan");
        cnl.add("Angel");
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        cnl.add("Centaur");
        cnl.add("Centaur");
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps = new PredictSplits("Gd", "Gd01", cnl);
        aps.add(ps);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Angel"); 
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Gd01").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Titan");
        cnl.add("Angel");
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        cnl.add("Centaur");
        cnl.add("Centaur");
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps = new PredictSplits("Bk", "Bk10", cnl);
        aps.add(ps);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Angel"); 
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Titan");
        cnl.add("Angel");
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        cnl.add("Centaur");
        cnl.add("Centaur");
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps = new PredictSplits("Br", "Br12", cnl);
        aps.add(ps);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Angel"); 
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Titan");
        cnl.add("Angel");
        cnl.add("Gargoyle");
        cnl.add("Gargoyle");
        cnl.add("Centaur");
        cnl.add("Centaur");
        cnl.add("Ogre");
        cnl.add("Ogre");
        ps = new PredictSplits("Rd", "Rd12", cnl);
        aps.add(ps);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Angel"); 
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Rd12").revealCreatures(cnl);
        aps.getLeaf("Gr07").split(4, "Gr12", turn);
        cnl.clear();
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Gr07").revealCreatures(cnl);
        aps.getLeaf("Gr07").addCreature("Troll");
        cnl.clear();
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Gr12").revealCreatures(cnl);
        aps.getLeaf("Gr12").addCreature("Cyclops");
        aps.getLeaf("Bu08").split(4, "Bu12", turn);
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Bu08").revealCreatures(cnl);
        aps.getLeaf("Bu08").addCreature("Centaur");
        cnl.clear();
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Bu12").revealCreatures(cnl);
        aps.getLeaf("Bu12").addCreature("Cyclops");
        aps.getLeaf("Gd01").split(4, "Gd12", turn);
        cnl.clear();
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Gd01").revealCreatures(cnl);
        aps.getLeaf("Gd01").addCreature("Troll");
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Gd12").revealCreatures(cnl);
        aps.getLeaf("Gd12").addCreature("Centaur");
        aps.getLeaf("Bk10").split(4, "Bk03", turn);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Bk03").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Bk03").revealCreatures(cnl);
        aps.getLeaf("Bk03").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Centaur");
        aps.getLeaf("Br12").split(4, "Br07", turn);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Br07").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Br07").revealCreatures(cnl);
        aps.getLeaf("Br07").addCreature("Warlock");
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Ogre");
        aps.getLeaf("Rd12").split(4, "Rd03", turn);
        cnl.clear();
        cnl.add("Gargoyle"); 
        aps.getLeaf("Rd12").revealCreatures(cnl);
        aps.getLeaf("Rd12").addCreature("Gargoyle");
        aps.printLeaves();
        assertEquals(aps.getLeaf("Bk03").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Bk10").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Br07").numUncertainCreatures(), 3);
        assertEquals(aps.getLeaf("Br12").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Bu08").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Bu12").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Gd01").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Gr07").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gr12").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Rd03").numUncertainCreatures(), 4);
        assertEquals(aps.getLeaf("Rd12").numUncertainCreatures(), 3);

        turn = 2;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Gr07").revealCreatures(cnl);
        aps.getLeaf("Gr07").addCreature("Troll");
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Gr12").revealCreatures(cnl);
        aps.getLeaf("Gr12").addCreature("Centaur");
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Gd01").revealCreatures(cnl);
        aps.getLeaf("Gd01").addCreature("Centaur");
        cnl.clear();
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Gd12").revealCreatures(cnl);
        aps.getLeaf("Gd12").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Lion");
        cnl.clear();
        cnl.add("Titan"); 
        aps.getLeaf("Rd12").revealCreatures(cnl);
        aps.getLeaf("Rd12").addCreature("Warlock");
        cnl.clear();
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Rd03").revealCreatures(cnl);
        aps.getLeaf("Rd03").addCreature("Troll");
        aps.printLeaves();
        assertEquals(aps.getLeaf("Bk03").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Bk10").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Br07").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Br12").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Bu08").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Bu12").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Gd01").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gr07").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gr12").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Rd03").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Rd12").numUncertainCreatures(), 1);

        turn = 3;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Bu08").revealCreatures(cnl);
        aps.getLeaf("Bu08").addCreature("Ogre");
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Bu12").revealCreatures(cnl);
        aps.getLeaf("Bu12").addCreature("Centaur");
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Gd01").revealCreatures(cnl);
        aps.getLeaf("Gd01").addCreature("Ogre");
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Bk03").revealCreatures(cnl);
        aps.getLeaf("Bk03").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Ogre");
        cnl.clear();
        cnl.add("Gargoyle"); 
        aps.getLeaf("Rd03").revealCreatures(cnl);
        aps.getLeaf("Rd03").addCreature("Gargoyle");
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Rd12").revealCreatures(cnl);
        aps.getLeaf("Rd12").addCreature("Lion");
        aps.printLeaves();
        assertEquals(aps.getLeaf("Bk03").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Bk10").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Br07").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Br12").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Bu08").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Bu12").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gd01").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gr07").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gr12").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Rd03").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Rd12").numUncertainCreatures(), 0);

        turn = 4;
        Log.debug("Turn " + turn);
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Gr07").revealCreatures(cnl);
        aps.getLeaf("Gr07").addCreature("Troll");
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Gr12").revealCreatures(cnl);
        aps.getLeaf("Gr12").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Bu08").revealCreatures(cnl);
        aps.getLeaf("Bu08").addCreature("Lion");
        aps.getLeaf("Gd01").split(2, "Gd07", turn);
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Gd01").revealCreatures(cnl);
        aps.getLeaf("Gd01").addCreature("Troll");
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Gd12").revealCreatures(cnl);
        aps.getLeaf("Gd12").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Cyclops"); 
        aps.getLeaf("Bk03").revealCreatures(cnl);
        aps.getLeaf("Bk03").addCreature("Cyclops");
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Bk10").revealCreatures(cnl);
        aps.getLeaf("Bk10").addCreature("Ogre");
        cnl.clear();
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Troll");
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Rd03").revealCreatures(cnl);
        aps.getLeaf("Rd03").addCreature("Troll");
        aps.printLeaves();
        assertEquals(aps.getLeaf("Bk03").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Bk10").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Br07").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Br12").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Bu08").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Bu12").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gd01").numUncertainCreatures(), 3);
        assertEquals(aps.getLeaf("Gd07").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gr07").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gr12").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Rd03").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Rd12").numUncertainCreatures(), 0);

        turn = 5;
        Log.debug("Turn " + turn);
        aps.getLeaf("Gr07").split(2, "Gr05", turn);
        aps.getLeaf("Gr12").split(2, "Gr10", turn);
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Gr05").revealCreatures(cnl);
        aps.getLeaf("Gr05").addCreature("Ogre");
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Gr07").revealCreatures(cnl);
        aps.getLeaf("Gr07").addCreature("Ranger");
        aps.getLeaf("Bu08").split(2, "Bu02", turn);
        cnl.clear();
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Bu08").revealCreatures(cnl);
        aps.getLeaf("Bu08").addCreature("Minotaur");
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Bu12").revealCreatures(cnl);
        aps.getLeaf("Bu12").addCreature("Centaur");
        aps.getLeaf("Gd12").split(2, "Gd11", turn);
        aps.getLeaf("Gd12").merge(aps.getLeaf("Gd11"), turn);
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Gd07").revealCreatures(cnl);
        aps.getLeaf("Gd07").addCreature("Lion");
        aps.getLeaf("Bk03").split(2, "Bk04", turn);
        aps.getLeaf("Bk10").split(2, "Bk07", turn);
        aps.getLeaf("Bk10").merge(aps.getLeaf("Bk07"), turn);
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Bk03").revealCreatures(cnl);
        aps.getLeaf("Bk03").addCreature("Ogre");
        aps.getLeaf("Br12").split(2, "Br10", turn);
        aps.getLeaf("Gr10").removeCreature("Gargoyle");
        aps.getLeaf("Gr10").removeCreature("Gargoyle");
        cnl.clear();
        cnl.add("Ogre"); 
        aps.getLeaf("Br07").revealCreatures(cnl);
        aps.getLeaf("Br07").addCreature("Ogre");
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Br12").revealCreatures(cnl);
        aps.getLeaf("Br12").addCreature("Troll");
        aps.getLeaf("Rd03").split(2, "Rd04", turn);
        aps.getLeaf("Rd12").split(2, "Rd10", turn);
        cnl.clear();
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Rd12").revealCreatures(cnl);
        aps.getLeaf("Rd12").addCreature("Cyclops");
        aps.printLeaves();
        assertEquals(aps.getLeaf("Bk03").numUncertainCreatures(), 3);
        assertEquals(aps.getLeaf("Bk04").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Bk10").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Br07").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Br10").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Br12").numUncertainCreatures(), 4);
        assertEquals(aps.getLeaf("Bu02").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Bu08").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Bu12").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gd01").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gd07").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gr05").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Gr07").numUncertainCreatures(), 3);
        assertEquals(aps.getLeaf("Gr12").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Rd03").numUncertainCreatures(), 5);
        assertEquals(aps.getLeaf("Rd04").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Rd10").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Rd12").numUncertainCreatures(), 3);

        turn = 6;
        Log.debug("Turn " + turn);
        aps.getLeaf("Bk04").removeCreature("Gargoyle");
        aps.getLeaf("Bk04").removeCreature("Gargoyle");
        cnl.clear();
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Gr05").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Rd10").revealCreatures(cnl);
        aps.getLeaf("Rd10").removeCreature("Centaur");
        aps.getLeaf("Gr07").removeCreature("Angel");
        aps.getLeaf("Gr05").addCreature("Angel");
        aps.getLeaf("Rd10").removeCreature("Centaur");
        aps.getLeaf("Gr05").removeCreature("Ogre");
        cnl.clear();
        cnl.add("Angel"); 
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Gr05").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Ranger"); 
        aps.getLeaf("Gr07").revealCreatures(cnl);
        aps.getLeaf("Gr07").addCreature("Ranger");
        cnl.clear();
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Gr12").revealCreatures(cnl);
        aps.getLeaf("Gr12").addCreature("Lion");
        aps.getLeaf("Bu12").split(2, "Bu11", turn);
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Cyclops"); 
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Bu12").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Lion"); 
        cnl.add("Centaur"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Gd07").revealCreatures(cnl);
        aps.getLeaf("Gd07").removeCreature("Centaur");
        aps.getLeaf("Bu12").removeCreature("Centaur");
        aps.getLeaf("Bu08").removeCreature("Angel");
        aps.getLeaf("Bu12").addCreature("Angel");
        aps.getLeaf("Bu12").removeCreature("Centaur");
        aps.getLeaf("Gd07").removeCreature("Lion");
        aps.getLeaf("Gd07").removeCreature("Centaur");
        cnl.clear();
        cnl.add("Titan"); 
        cnl.add("Angel"); 
        cnl.add("Cyclops"); 
        cnl.add("Centaur"); 
        aps.getLeaf("Bu12").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Centaur"); 
        aps.getLeaf("Bu12").revealCreatures(cnl);
        aps.getLeaf("Bu12").addCreature("Centaur");
        aps.getLeaf("Gd12").split(2, "Gd11", turn);
        aps.getLeaf("Gd12").merge(aps.getLeaf("Gd11"), turn);
        cnl.clear();
        cnl.add("Angel"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Gd01").revealCreatures(cnl);
        cnl.clear();
        cnl.add("Angel"); 
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        cnl.add("Gargoyle"); 
        cnl.add("Gargoyle"); 
        aps.getLeaf("Rd03").revealCreatures(cnl);
        aps.getLeaf("Rd03").removeCreature("Troll");
        aps.getLeaf("Gd01").removeCreature("Angel");
        aps.getLeaf("Rd03").removeCreature("Gargoyle");
        aps.getLeaf("Gd01").removeCreature("Ogre");
        aps.getLeaf("Rd03").removeCreature("Gargoyle");
        aps.getLeaf("Gd01").removeCreature("Troll");
        cnl.clear();
        cnl.add("Troll"); 
        aps.getLeaf("Rd03").revealCreatures(cnl);
        aps.getLeaf("Rd03").addCreature("Troll");
        aps.getLeaf("Gd01").removeCreature("Troll");
        aps.getLeaf("Gd01").removeCreature("Ogre");
        aps.getLeaf("Rd03").removeCreature("Angel");
        aps.getLeaf("Gd01").removeCreature("Ogre");
        cnl.clear();
        cnl.add("Troll"); 
        cnl.add("Troll"); 
        aps.getLeaf("Rd03").revealCreatures(cnl);
        aps.getLeaf("Bk10").split(2, "Bk01", turn);
        cnl.clear();
        cnl.add("Ogre"); 
        cnl.add("Ogre"); 
        aps.getLeaf("Br07").revealCreatures(cnl);
        aps.getLeaf("Br07").addCreature("Troll");
        aps.printLeaves();
        assertEquals(aps.getLeaf("Bk01").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Bk03").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Bk10").numUncertainCreatures(), 3);
        assertEquals(aps.getLeaf("Br07").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Br10").numUncertainCreatures(), 2);
        assertEquals(aps.getLeaf("Br12").numUncertainCreatures(), 4);
        assertEquals(aps.getLeaf("Bu02").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Bu08").numUncertainCreatures(), 1);
        assertEquals(aps.getLeaf("Bu11").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Bu12").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gd12").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gr05").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gr07").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Gr12").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Rd03").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Rd04").numUncertainCreatures(), 0);
        assertEquals(aps.getLeaf("Rd12").numUncertainCreatures(), 0);

        Log.debug("\ntest %s ends");
    }
}
