/* rexx - ViewIt: install ViewIt's DLL and create its object */

Parse source . . __rexx_name;
__rexx_dir = Filespec('D',__rexx_name)||Filespec('P',__rexx_name)

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;           

Say 'Installing ViewIt and creating its object on Desktop. Please wait...'

sObject='ViewIt'
sObjectID='<VIEWIT>'
sDLL='ViewIt.dll'
sTitle='ViewIt 1.2'

system_dll=FileSpec('Drive',Value('SYSTEM_INI',,'OS2ENVIRONMENT'))||'\OS2\DLL';
rc=SysDeregisterObjectClass('ViewIt');
Address CMD '@ERASE 'system_dll'\'sDLL' 2>NUL';
Address CMD '@COPY '__rexx_dir''sDLL' 'system_dll' 2>NUL';

If rc <> 0                 /* registered OK ?                */
   Then Do;
     Say  sObject": could not replace "sDLL", rc = "rc".";
     Say  sObject": delete the object and "sDLL" from "system_dll" directory.";
     Exit;
   End;

rc=SysRegisterObjectClass(sObject,system_dll||'\'sDLL);

If rc <> 1                 /* registered OK ?                */
   Then Do;
     Say  sObject": could not register its object class, rc = "rc".";
     Exit;
   End;

rc=SysCreateObject(sObject,sTitle,'<WP_DESKTOP>', ,
   'OBJECTID='sObjectID';','ReplaceIfExists');

If rc <> 1                 /* registered OK ?                */
   Then Do;
     Say  sObject": could not create its object, rc = "rc".";
   End;
Exit;

