/*************************************************/
/* Installationsroutine fr LBACK und LREST      */
/*                                               */
/*         von    P. Schnweitz                  */
/*                Rechbergstr. 12                */
/*                71665 Vaihingen / Enz          */
/*                                               */
/*         ab     Version 1.20                   */
/*                                               */
/*************************************************/

"@echo off"
lwz = ""
lwb = ""
ipf = ":\LBACK"
lpf = ":\LBACK\LOGS"
anfang:
if lwz = "" then
   lwz = "C"
if lwb = "" then
   lwb = "C"
if length(lwz) \= 1 then do
   say " Fehler Ziellaufwerk "
   signal eingabe
end
if length(lwb) \= 1 then do
   say " Fehler Bootlaufwerk "
   signal eingabe
end
say "*************************************************"
say "* Installiert wird auf Laufwerk " lwz ":            *"
say "* OS/2 Bootlaufwerk ist         " lwb ":            *"
say "*************************************************"
say "* Sind die Eingaben richtig ??                  *"
say "* Bitte mit J / N / Ende antworten              *"
say "*************************************************"
pull antwort
if antwort = "J" |,
   antwort = "j" then signal install
if antwort = "ende" |,
   antwort = "ENDE" then exit;
eingabe:
say "Bitte Ziellaufwerk eingeben :"
pull lwz
lwz = substr(lwz,1,1)
say "Bitte Bootlaufwerk eingeben :"
pull lwb
lwb = substr(lwb,1,1)
signal anfang

install:
say "erzeuge Verzeichnis" lwz||ipf
"MD" lwz||ipf||" > nul:"
say "erzeuge Verzeichnis" lwz||lpf
"MD" lwz||lpf||" > nul:"
say "Kopiere Programme nach " lwz||ipf
"XCOPY *.doc" lwz||ipf||"\*.* > nul:"
"XCOPY *.exe" lwz||ipf||"\*.* > nul:"
"XCOPY *.dll" lwz||ipf||"\*.* > nul:"
"XCOPY *.ico" lwz||ipf||"\*.* > nul:"
"XCOPY *.cmd" lwz||ipf||"\*.* > nul:"
say "Kopiere Hilfetexte nach " lwz||lpf
"XCOPY *.hlp" lwz||lpf||"\*.* > nul:"

adatei=lwb||":\config.tem"
bdatei=lwb||":\config.###"
zeile="SET LBACK="||lwz||lpf
"copy "||lwb||":\config.sys "||lwb||":\*.### > nul:"
if lines(bdatei) = 0 then do; say 'CONFIG.SYS nicht gefunden !' ; Exit ;end
do forever
  lz = linein(bdatei)
  lza = translate(lz)
  if pos("SET LBACK",strip(lza),1) = 1 then do
     lz = "rem "||lz
  end
  rc = lineout(adatei,lz)
  if rc \= 0 then do; say 'FEHLER' ; EXIT ; END
  if lines(bdatei) = 0 then leave
end
rc  = lineout(adatei,zeile)
if rc \= 0 then do; say 'FEHLER' ; EXIT ; END
rc = lineout(adatei)
rc = lineout(bdatei)
"copy "||lwb||":\config.tem "||lwb||":\*.sys > nul:"
"del "||lwb||":\config.tem"


/* Generieren der Iconen                  */
/* Laden REXXUTIL */
call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
call sysloadfuncs
call SysCls

lpfad = lwz||ipf||"\"
filespec = lpfad"lback.exe"
call SysFileTree filespec, 'file', 'F'
IF file.0 = 0
  THEN do
     SAY lpfad"LBACK.EXE nicht gefunden."
     EXIT
END

classname = 'WPFolder'
location = '<WP_DESKTOP>'
title = "L-BACK SHAREWARE"
icon = lpfad"lfold.ico"
setup='OBJECTID=<LBACK_OS2>;ICONFILE 'icon';'
call BldObj

classname = 'WPProgram'
title="L-Backup V1.31S"
xe = lpfad"lback.exe"
location = '<LBACK_OS2>'
icon = lpfad"lback.ico"
setup = 'PROGTYPE=FULLSCREEN;EXENAME='xe';STARTUPDIR='lpfad';ICONFILE 'icon';'
call BldObj

title="L-Restore V1.31S"
xe = lpfad"lrest.exe"
icon = lpfad"lrest.ico"
setup = 'PROGTYPE=FULLSCREEN;EXENAME='xe';STARTUPDIR='lpfad';ICONFILE 'icon';'
call BldObj

title="L-Dokumentation"
xe = "e.exe"
icon = lpfad"ldoc.ico"
para = lpfad"lback.doc"
setup = 'EXENAME='xe';PARAMETERS='para';STARTUPDIR='lpfad';ICONFILE 'icon';'
call BldObj

ende:
say "*************************************************"
say "* LBACK ist jetzt installiert                   *"
say "* Aufruf      L-Backup   : BACKUP               *"
say "* Aufruf      L-Restore  : RESTORE              *"
say "*                                               *"
say "* Die alte CONFIG.SYS heit nun CONFIG.### !    *"
say "*                                               *"
say "* Es wurde die Zeile:                           *"
say "* SET LBACK="||lwz||":\LBACK\LOGS                      *"
say "* in die CONFIG.SYS eingefgt.                  *"
say "*                                               *"
say "*************************************************"
say "*                                               *"
say "*             RETURN   fr Ende                 *"
say "*                                               *"
say "*************************************************"
pull antwort

EXIT


BldObj:
call charout , 'Erstelle : 'title
result = SysCreateObject(classname, title, location, setup)
If result = 1 then call charout ,'...  Aufruf erstellt ! '
Else               call charout ,'...  nicht erstellt ! '
SAY ' '
RETURN

