<?php
set_error_handler ('php_error_handler');
error_reporting (E_ALL | E_STRICT); ini_set ('display_errors', 1);
date_default_timezone_set ('Europe/Moscow');

ini_set ('memory_limit', '2048M'); gc_enable();
ini_set ('max_execution_time', 0);

/* * */

$keep_line_breaks = 0;
if (isset ($argv[1]) && $argv[1] == '--keep-line-breaks') $keep_line_breaks = 1;

$file_name = $argv[1];
if (!$file_name || !file_exists ($file_name)) {
    $file_name = $argv[2];
    if (!$file_name || !file_exists ($file_name)) exit;
}

/* * */

$file = fopen ($file_name, 'r');
$book = fread ($file, filesize ($file_name));
fclose ($file); unset ($file);

$book = explode ("\n", $book);

if (!isset ($dirname)) $dirname = dirname (__FILE__);

$file = fopen ($dirname.'/Template/Book.fb2', 'r');
$template = fread ($file, filesize ($dirname.'/Template/Book.fb2'));
fclose ($file); unset ($file);

if (file_exists ($dirname.'/Template/BookCover.png')) {
    $file = fopen ($dirname.'/Template/BookCover.png', 'r');
    $cover = fread ($file, filesize ($dirname.'/Template/BookCover.png')); $cover_image_type = 'png';
    fclose ($file); unset ($file);
}

if (file_exists ($dirname.'/Template/BookCover.jpg')) {
    $file = fopen ($dirname.'/Template/BookCover.jpg', 'r');
    $cover = fread ($file, filesize ($dirname.'/Template/BookCover.jpg')); $cover_image_type = 'jpeg';
    fclose ($file); unset ($file);
}

$template = strreplace ($template, '%DATE%', date ('Y-m-d'));
$template = strreplace ($template, '%DATE-RU%', date ('d.m.Y'));
$template = strreplace ($template, '%VERSION%', date ('Ymd'));
$template = strreplace ($template, '%COVER%', base64_encode ($cover));
$template = strreplace ($template, '%COVER_IMAGE_TYPE%', $cover_image_type);
$template = implode ("\n", compress (explode ("\n", $template)));

$fb2 = addImages ($template, $book); unset ($template);

$book = compress ($book);
$book = changeEncoding ($book);
$book = removeSimpleTags ($book, $keep_line_breaks);
$book = insertH1Sections ($book);
$book = insertH2Sections ($book);
$book = removeEmptySections ($book);
$book = insertCode ($book);
$book = insertArtwork ($book);
$book = insertLists ($book);
$book = insertParagraphs ($book);
$book = removeEmptyParagraphs ($book);
$book = addBoundParagraphs ($book);
$book = addParagraphBreaks ($book);
$book = replaceSpecialSymbols ($book);

$fb2 = strreplace ($fb2, '%TEXT%', implode ("\n", $book));
$fb2 = strreplace ($fb2, "\n".'</code>', '</code>');

if ($keep_line_breaks) {
    $fb2 = strreplace ($fb2, '--[ BR ]--', '<br/>');
    $fb2 = strreplace ($fb2, '<p>'."\n".'<br/>', '<p>');
    $fb2 = strreplace ($fb2, '<br/>'."\n".'</p>', '</p>');

    $fb2 = strreplace ($fb2, '<br/></code>', '</code>');
    $fb2 = strreplace ($fb2, ' </code>', '</code>');
}

$fb2 = strreplace ($fb2, '<p>'."\n".'</p>'."\n", '');
$fb2 = strreplace ($fb2, '<p> </p>', '<p>&nbsp;</p>', '');
$fb2 = strreplace ($fb2, '<p>'."\n".' '."\n".'</p>', '<p>&nbsp;</p>', '');

if (strpos ($file_name, '.ipf')) {
    $inf_file_name = strreplace ($file_name, '.ipf', '.inf');
    $fb2_file_name = strreplace ($file_name, '.ipf', '.fb2');

    if (file_exists ($fb2_file_name)) unlink ($fb2_file_name);
        
    $file = fopen ($fb2_file_name, 'w');
    fwrite ($file, $fb2);
    fclose ($file); unset ($file);

    touch ($inf_file_name, strtotime (date ('Y-m-d')));
    touch ($fb2_file_name, strtotime (date ('Y-m-d')));
}

exit;

/* * */

function compress ($lines) {
    $result = array ();

    for ($cntr = 0; $cntr < count ($lines); $cntr ++) {
         $line = $lines[$cntr]; if (!$line) continue;

         $result[] = rtrim ($line);

         if ($cntr % 1000 == 0) yield_time ();
    }

    return $result;
}

function removeSimpleTags ($book, $keep_line_breaks) { 
    $result = array ();
    $code = 0;

    for ($cntr = 0; $cntr < count ($book); $cntr ++) {
         $line = $book[$cntr];

         if ($line == '') continue;
         if ($line == '.*') continue;
         if ($line == ':userdoc.' || $line == ':euserdoc.') continue;
         if (strpos ($line, ':title.') !== false) continue;

         if ($code == 1 && $line[0] == ':') $code = 0;
         if ($code == 0 && strpos ($line, 'facename=Courier') !== false) $code = 1;

         if (!$keep_line_breaks) {
             if ($line == '.br' && !$code) $line = '';
         } else {
             if ($line == '.br' && !$code) $line = '--[ BR ]--';
         }

         if (strpos ($line, ':color') !== false) {
             $line = removeTag ($line, 'color');
         }

         if (strpos ($line, 'facename=default') !== false) {
             $line = removeTag ($line, 'font');
         }

         if (strpos ($line, '&') !== false) {
             $line = strreplace ($line, '&amp.', '&#038;');
             $line = strreplace ($line, '&colon.', ':');
             $line = strreplace ($line, '&per.', '.');
         }

         if (strpos ($line, '<') !== false || 
             strpos ($line, '>') !== false) {
             $line = strreplace ($line, '<', '&lt;');
             $line = strreplace ($line, '>', '&gt;');
         }

         if ($line) {
             $result[] = $line;
         }

         if ($cntr % 1000 == 0) yield_time ();
    }

    return $result;
}

function removeTag ($line, $tag) {
    $position = 0;
    while ($position !== false) {
        $position = strpos ($line, ':'.$tag, $position);

        if ($position !== false) {
            $begin = substr ($line, 0, $position);
            $line = substr ($line, $position);

            $parts = explode ('.', $line);
            $parts[0] = '';
            $line = implode ('.', $parts);
            $line = substr ($line, 1);

            $line = $begin.$line;
        } else {
            break;
        }
    }

    return $line;
}

function insertH1Sections ($book) {
    $result = array ();
    $section = 0;

    for ($cntr = 0; $cntr < count ($book); $cntr ++) {
         $line = $book[$cntr];

         if (substr ($line, 0, 4) == ':h1.') {
             if ($section == 1) {
                 $result[] = '</section><!-- 1 -->';
                 $section = 0;
             }

             if ($section == 0) {
                 $title = substr ($line, 4);
                 $result[] = '<section><!-- 1 -->';
                 $result[] = '<title><p>'.$title.'</p></title>';
                 $section = 1;

                 $line = '';
             }
         }

         if ($line) {
             $result[] = $line;
         }

         if ($cntr % 1000 == 0) yield_time ();
    }

    if ($section > 0) {
        $result[] = '</section><!-- 1 -->';
    }

    return $result;
}

function insertH2Sections ($book) {
    $result = array ();
    $section = 0;

    for ($cntr = 0; $cntr < count ($book); $cntr ++) {
         $line = $book[$cntr];

         if (substr ($line, 0, 4) == ':h2.') {
             if ($section == 1) {
                 $result[] = '</section><!-- 2 -->';
                 $section = 0;
             }

             if ($section == 0) {
                 $title = substr ($line, 4);
                 $result[] = '<section><!-- 2 -->';
                 $result[] = '<title><p>'.$title.'</p></title>';
                 $section = 1;

                 $line = '';
             }
         }

         if ($line == '</section><!-- 1 -->') {
             if ($section == 1) {
                 $result[] = '</section><!-- 2 -->';
                 $section = 0;
             }
         }

         if ($line) {
             $result[] = $line;
         }

         if ($cntr % 1000 == 0) yield_time ();
    }

    if ($section > 0) {
        $result[] = '</section><!-- 2 -->';
    }

    return $result;
}

function removeEmptySections ($book) {
    /*
    $result = array ();
    $section = 0;

    for ($cntr = 0; $cntr < count ($book); $cntr ++) {
         $line = $book[$cntr];


         if ($section == 0 && $line == '<section><!-- 1 -->' &&
             $cntr != count ($book) - 1 && $book[$cntr + 1] == '<title><p>&#160;</p></title>') {

             $section = 1; continue;
         }

         if ($section == 1 && $line == '</section><!-- 1 -->') {
             $section = 0; continue;
         }

         if ($section == 0) {
             $result[] = $line;
         }

         if ($cntr % 1000 == 0) yield_time ();
    }

    return $result;
    */

    return $book;
}

function insertCode ($book) {
    $result = array ();
    $code = 0;

    for ($cntr = 0; $cntr < count ($book); $cntr ++) {
         $line = $book[$cntr];

         if ($code == 1) {
             if ($line[0] == ':' || $line[0] == '<') {
                 $code = 0;
                 $result[] = '</code>';
                 $result[] = '</p>';
             }
         }
         if ($code == 0 && strpos ($line, 'facename=Courier') !== false) {
             $code = 1;
             $result[] = '<p>';
             $result[] = '<code>';
             continue;
         }

         if ($code == 1 && $line != '.br') {
             $previous_line = $book[$cntr - 1];
             $previous_result_line = $result[count ($result) - 1];

             if ($previous_line != '.br' && $previous_result_line != '<code>') {
                 $result[count ($result) - 1] .= ' '.$line;
                 $line = '';
             }
         }
         if ($code == 1 && $line == '.br') {
             if ($cntr != count ($book) - 1 && $book[$cntr + 1] == '.br') {
                 $line = ' ';
             } else {
                 $line = '';
             }
         }

         if ($line) {
             if ($code == 1) {
                 $result[] = '  '.$line;
             } else {
                 $result[] = $line;
             }
         }

         if ($cntr % 1000 == 0) yield_time ();
    }

    if ($code) {
         $result[] = '</code>';
         $result[] = '</p>';
    }

    return $result;
}

function insertArtwork ($book) {
    $result = array ();

    for ($cntr = 0; $cntr < count ($book); $cntr ++) {
         $line = $book[$cntr];

         if (substr ($line, 0, 9) == ':artwork ') {
             $result[] = '<empty-line/>';
             $result[] = '<image xlink:href="#'.getBitmapId ($line).'"/>';
             $result[] = '<empty-line/>';
         } else {
             $result[] = $line;
         }

         if ($cntr % 1000 == 0) yield_time ();
    }

    return $result;
}

function insertLists ($book) {
    $book = insertListBreaks ($book);
    $book = insertListHeaders ($book, 'ul');
    $book = insertListHeaders ($book, 'ol');
    $book = insertListHeaders ($book, 'sl');
    $book = formatListItems ($book);

    return $book;
}

function insertListBreaks ($book) {
    $result = array ();
    $list_level = 0;

    for ($cntr = 0; $cntr < count ($book); $cntr ++) {
         $line = $book[$cntr];
         $string = ltrim ($line);
         $s_3 = substr ($string, 0, 3);
         $s_4 = substr ($string, 0, 4);

         if ($s_3 == ':ul' || $s_3 == ':ol' || $s_3 == ':sl') {
             $list_level ++;

             if ($list_level == 1) {
                 $result[] = '<empty-line/>';
                 $result[] = $line;
                 $line = '';
             }
             if ($list_level > 1) {
                 $line = '';
             }
         }
         if ($s_4 == ':eul' || $s_4 == ':eol' || $s_4 == ':esl') {
             $list_level --;

             if ($list_level == 0) {
                 $result[] = $line;
                 $result[] = '<empty-line/>';
                 $line = '';
             }
         }

         if ($line) {
             $result[] = $line;
         }

         if ($cntr % 1000 == 0) yield_time ();
    }

    return $result;
}

function insertListHeaders ($book, $token) {
    $result = array ();

    for ($cntr = 0; $cntr < count ($book); $cntr ++) {
         $line = $book[$cntr];
         $string = ltrim ($line);

         if (substr ($string, 0, 3) == ':'.$token) {
             $line = '<p>';
         }
         if (substr ($string, 0, 4) == ':e'.$token) {
             $line = '</p>';
         }

         if ($line) {
             $result[] = $line;
         }

         if ($cntr % 1000 == 0) yield_time ();
    }

    return $result;
}

function formatListItems ($book) {
    $result = array ();

    for ($cntr = 0; $cntr < count ($book); $cntr ++) {
         $line = $book[$cntr];
         $string = ltrim ($line);

         if (substr ($string, 0, 3) == ':li') {
             $line = addLeadingSpaces ($line);
             $line = strreplace ($line, ':li.', '&#9642;&#160;');

             $result[] = '</p>';
             $result[] = '<p>';
         }

         if ($line) {
             $result[] = $line;
         }

         if ($cntr % 1000 == 0) yield_time ();
    }

    return $result;
}

function addLeadingSpaces ($line) {
    $new_line = trim ($line);

    for ($cntr = 0; $cntr < strlen ($line); $cntr ++) {
         if ($line[$cntr] == ' ') $new_line = '&#160;&#160;'.$new_line;
         else break;
    }

    return $new_line;
}

function insertParagraphs ($book) {
    $result = array ();
    $paragraph = 0;

    for ($cntr = 0; $cntr < count ($book); $cntr ++) {
         $line = $book[$cntr];

         if ($paragraph == 1) {
             if ($line[0] == ':' || $line[0] == '<') {
                 $result[] = '</p>';
                 $paragraph = 0;
             }
         }
         if ($paragraph == 0 && substr ($line, 0, 3) == ':p.') {
             $line = '<p>';
             $paragraph = 1;
         }

         if ($line) {
             $result[] = $line;
         }

         if ($cntr % 1000 == 0) yield_time ();
    }

    if ($paragraph) {
         $result[] = '</p>';
    }

    return $result;
}

function removeEmptyParagraphs ($book) {
    $result = array ();

    for ($cntr = 0; $cntr < count ($book); $cntr ++) {
         if (!$book[$cntr]) continue;

         if ($cntr != count ($book) - 1) {
             if ($book[$cntr] == '<p>' && $book[$cntr + 1] == '</p>') { 
                 $book[$cntr] = ''; 
                 $book[$cntr + 1] = '';
             }

             if ($book[$cntr] == '<p>' && $book[$cntr + 1] == '<p>') { 
                 $book[$cntr] = ''; 
             }
             if ($book[$cntr] == '</p>' && $book[$cntr + 1] == '</p>') { 
                 $book[$cntr] = ''; 
             }
         }

         if ($book[$cntr]) {
             $result[] = $book[$cntr];
         }

         if ($cntr % 1000 == 0) yield_time ();
    }

    return $result;
}

function addBoundParagraphs ($book) {
    $result = array ();
    $paragraph = 0; $inserted_paragraph = 0;

    for ($cntr = 0; $cntr < count ($book); $cntr ++) {
         $line = $book[$cntr];

         if ($paragraph == 1 && $line == '</p>') {
             $paragraph = 0;
         }
         if ($paragraph == 0 && $line == '<p>') {
             $paragraph = 1;
         }

         if ($paragraph == 1) {
             if ($inserted_paragraph == 1 && $line == '<p>') {
                 $inserted_paragraph = 0;
                 $result[] = '</p>';
                 $result[] = '<empty-line/>';
                 $result[] = '<p>'; continue;
             }
         }
         if ($paragraph == 0) {
             if ($inserted_paragraph == 1 && $line[0] == '<') {
                 $inserted_paragraph = 0;
                 $result[] = '</p>';
                 $result[] = $line; continue;
             }
             if ($inserted_paragraph == 0 && $line[0] != '<') {
                 $inserted_paragraph = 1;
                 $result[] = '<p>';
                 $result[] = $line; continue;
             }
         }

         $result[] = $line;

         if ($cntr % 1000 == 0) yield_time ();
    }

    return $result;
}

function addParagraphBreaks ($book) {
    $result = array ();

    for ($cntr = 0; $cntr < count ($book); $cntr ++) {
         if ($cntr != count ($book) - 2) {
             if ($book[$cntr] == '</p>' && $book[$cntr + 1] == '<p>' &&
                 strpos (' '.$book[$cntr + 2], '&#9642;&#160;') === false) { 

                 $result[] = $book[$cntr];
                 $result[] = '<empty-line/>';
                 continue;

             }
         }

         $result[] = $book[$cntr];

         if ($cntr % 1000 == 0) yield_time ();
    }

    return $result;
}

function replaceSpecialSymbols ($book) {
    $result = array ();

    for ($cntr = 0; $cntr < count ($book); $cntr ++) {
         if (strpos ($book[$cntr], '" (c)')) {
             $book[$cntr] = strreplace ($book[$cntr], '" (c)', '" &copy;');
         }

         $result[] = $book[$cntr];
    }

    return $result;
}

/* * */

function addImages ($template, $book) {
    $imgs = array ();
    $tags = array ();

    for ($cntr = 0; $cntr < count ($book); $cntr ++) {
         $line = rtrim ($book[$cntr]);
         if (strpos (' '.$line, ':artwork') === false) continue;

         $id = getBitmapId ($line);
         if (!isset ($imgs[$id])) {
             list ($file_name, $type) = getBitmapFileName ($line);

             $file = fopen ($file_name, 'r');
             $image = fread ($file, filesize ($file_name));
             fclose ($file); unset ($file);

             $imgs[$id] = array ($type, base64_encode ($image)); 
         }
    }

    foreach ($imgs as $id=>$image) {
        $tags[] = '<binary content-type="image/'.$image[0].'" id="'.$id.'">'.$image[1].'</binary>';
    }

    return strreplace ($template, '%IMAGES%', implode ("\n", $tags));
}

function getBitmapFileName ($line) {
    $line = strreplace (strreplace ($line, '/', '\\'), '.bmp\'.', '');

    $file_name = substr ($line, strrpos ($line, '\'') + 1); $type = '';
    if (file_exists ($file_name.'.png')) { $file_name .= '.png'; $type = 'png'; }
    if (file_exists ($file_name.'.jpg')) { $file_name .= '.jpg'; $type = 'jpeg'; }

    if (!$type) {
        print 'File not found: '.$file_name.'.{png|jpg}'."\n"; throw new Exception ();
    }

    return array ($file_name, $type);
}

function getBitmapId ($path) {
    $path = strreplace (strreplace ($path, '/', '\\'), '.bmp\'.', '');

    $parts = explode ('\\', $path);
    $bitmap = $parts[count ($parts) - 1];
    $folder = $parts[count ($parts) - 3];
    $folder = substr ($folder, strpos ($folder, '-') + 1);

    return $bitmap.'@'.$folder;
}

/* * */

function changeEncoding ($book) {
    $result = array ();

    $cp866  = '񦧨';
    $cp1251 = 'Ũ';

    for ($cntr = 0; $cntr < count ($book); $cntr ++) {
         $line = $book[$cntr];

         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9830;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#8226;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9788;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9654;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9664;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#8597;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#8252;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#8616;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#8593;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#8595;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#8594;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#8592;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#8596;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9650;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9660;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9617;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9618;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9619;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9474;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9508;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9569;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9570;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9558;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9557;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9571;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9553;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9559;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9565;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9564;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9563;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9488;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9492;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9524;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9516;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9500;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9472;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9532;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9566;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9567;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9562;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9556;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9577;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9574;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9568;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9552;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9580;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9575;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9576;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9572;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9573;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9561;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9560;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9554;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9555;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9579;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9578;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9496;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9484;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9608;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9604;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9612;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9616;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9600;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#176;' );
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#149;' ); // *
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#183;' ); // .
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#8730;'); 
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#8470;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#167;' );
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#164;' );
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, '&#9642;');
         $chr = ''; if (strpos ($line, $chr) !== false) $line = strreplace ($line, $chr, ' '      ); // &#160;

         $line = strtr ($line, $cp866, $cp1251);

         $result[] = $line;
    }

    return $result;
}

/* * */

function strreplace ($haystack, $needle, $str) { return str_replace ($needle, $str, $haystack); }
function yield_time () { if (function_exists ('proc_nice')) { proc_nice (abs (31)); } else { usleep (25); } }

function php_error_handler ($errno, $errstr, $errfile, $errline, $vars = null) { 
    die ("\n\n".'['.$errno.'] '.$errstr.' ('.strtr ($errfile, '\\', '/').', '.$errline.')'."\n\n");
}
